---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-SparkListenerApplicationStart

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 行273-280（ケースクラス定義）
- E-02: `core/src/main/scala/org/apache/spark/SparkContext.scala` 行2936-2941（postApplicationStart）
- E-03: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 行54-55（doPostEvent）
- E-04: `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` 行117-152（onApplicationStart）
- E-05: `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` 行178-180（onApplicationStart）
- E-06: `core/src/main/scala/org/apache/spark/util/JsonProtocol.scala` 行302-315（applicationStartToJson）
- E-07: `core/src/main/scala/org/apache/spark/util/JsonProtocol.scala` 行1124-1133（applicationStartFromJson）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerApplicationStartはappName, appId, time, sparkUser, appAttemptId, driverLogs, driverAttributesの7フィールドを持つ | E-01 | ○ |
| C-02 | SparkContext.postApplicationStartでイベントが発火する | E-02 | ○ |
| C-03 | appIdはSome(applicationId)として渡される | E-02 | ○ |
| C-04 | SparkListenerBus.doPostEventで専用のcaseブランチがある | E-03 | ○ |
| C-05 | AppStatusListenerがassert(event.appId.isDefined)でappIdの存在を確認する | E-04 | ○ |
| C-06 | AppStatusListenerがApplicationAttemptInfoを生成しKVStoreに書き込む | E-04 | ○ |
| C-07 | EventLoggingListenerがflushLogger=trueでログ記録する | E-05 | ○ |
| C-08 | JsonProtocolで"App Name", "App ID", "Timestamp", "User"等のキー名が使用される | E-06, E-07 | ○ |
| C-09 | driverLogsとdriverAttributesはOption型である | E-01 | ○ |
| C-10 | schedulerBackend.getDriverLogUrlsからdriverLogsを取得する | E-02 | ○ |
| C-11 | schedulerBackend.getDriverAttributesからdriverAttributesを取得する | E-02 | ○ |
| C-12 | アプリケーション起動時に1回のみ発火する | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのClaimにソースコードからの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 7フィールドの型定義が正しいか確認
- [ ] postApplicationStartの呼び出しタイミングが正しいか確認
- [ ] AppStatusListenerのKVStore書き込み内容が正確か確認
