---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-SparkListenerApplicationEnd

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 行283-285（ケースクラス定義）
- E-02: `core/src/main/scala/org/apache/spark/SparkContext.scala` 行2945-2953（postApplicationEnd）
- E-03: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 行56-57（doPostEvent）
- E-04: `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` 行192-210（onApplicationEnd）
- E-05: `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` 行182-184（onApplicationEnd）
- E-06: `core/src/main/scala/org/apache/spark/util/JsonProtocol.scala` 行317-325（applicationEndToJson）
- E-07: `core/src/main/scala/org/apache/spark/deploy/history/FsHistoryProvider.scala` 行1508（APPL_END_EVENT_PREFIX）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerApplicationEndはtime, exitCodeの2フィールドを持つ | E-01 | ○ |
| C-02 | exitCodeはOption[Int]型でデフォルトNone | E-01 | ○ |
| C-03 | SparkContext.postApplicationEndでイベントが発火する | E-02 | ○ |
| C-04 | System.currentTimeMillisで終了時刻を取得しSome(exitCode)を渡す | E-02 | ○ |
| C-05 | reportDriverHeartBeatMetricsの最終報告がtry-catch内で実行される | E-02 | ○ |
| C-06 | SparkListenerBus.doPostEventで専用のcaseブランチがある | E-03 | ○ |
| C-07 | AppStatusListenerが終了時刻と完了フラグをKVStoreに更新する | E-04 | ○ |
| C-08 | EventLoggingListenerがflushLogger=trueでログ記録する | E-05 | ○ |
| C-09 | JsonProtocolで"Timestamp"と"ExitCode"キーが使用される | E-06 | ○ |
| C-10 | FsHistoryProviderがAPPL_END_EVENT_PREFIXで高速フィルタリングを行う | E-07 | ○ |
| C-11 | SparkListenerApplicationStartの対となるイベントである | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのClaimにソースコードからの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] time, exitCodeの2フィールド構成が正しいか確認
- [ ] postApplicationEndの呼び出しタイミングが正しいか確認
- [ ] AppStatusListenerの更新内容が正確か確認
