---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-SparkListenerMiscellaneousProcessAdded

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 行236-239（ケースクラス定義）
- E-02: `core/src/main/scala/org/apache/spark/scheduler/MiscellaneousProcessDetails.scala` 行28-31（詳細クラス定義）
- E-03: `core/src/main/scala/org/apache/spark/scheduler/cluster/CoarseGrainedSchedulerBackend.scala` 行243-245（イベント発火）
- E-04: `core/src/main/scala/org/apache/spark/scheduler/cluster/CoarseGrainedClusterMessage.scala` 行142-144（メッセージ定義）
- E-05: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 行100（default case）
- E-06: `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` 行110-113（onOtherEvent内のパターンマッチ）
- E-07: `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` 行1436-1442（onMiscellaneousProcessAdded実装）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerMiscellaneousProcessAddedはtime, processId, infoの3フィールドを持つ | E-01 | ○ |
| C-02 | @Since("3.2.0")で導入された | E-01 | ○ |
| C-03 | MiscellaneousProcessDetailsはhostPort, cores, logUrlInfoの3フィールドを持つSerializable | E-02 | ○ |
| C-04 | CoarseGrainedSchedulerBackend.DriverEndpointでMiscellaneousProcessAddedメッセージを処理する | E-03 | ○ |
| C-05 | listenerBus.postでSparkListenerMiscellaneousProcessAddedを発火する | E-03 | ○ |
| C-06 | MiscellaneousProcessAddedメッセージがCoarseGrainedClusterMessageの一部として定義されている | E-04 | ○ |
| C-07 | SparkListenerBusのdoPostEventには専用caseブランチがない | E-05 | ○ |
| C-08 | default caseでonOtherEventに渡される | E-05 | ○ |
| C-09 | AppStatusListenerのonOtherEvent内でパターンマッチされる | E-06 | ○ |
| C-10 | onMiscellaneousProcessAddedでprocessLogs, hostPort, isActiveを設定しKVStore書き込み | E-07 | ○ |
| C-11 | 非同期配信（LiveListenerBus経由）である | E-03 | ○ |
| C-12 | MiscellaneousProcessDetailsはcores（Int型）を含む | E-02 | ○ |
| C-13 | logUrlInfoはMap[String, String]型である | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのClaimにソースコードからの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 3フィールドの型定義が正しいか確認
- [ ] MiscellaneousProcessDetailsのフィールド構成が正しいか確認
- [ ] onOtherEvent経由での配信メカニズムが正しいか確認
- [ ] クラスタマネージャからのメッセージ送信パスが網羅されているか確認
