---
generated_at: 2026-02-04 10:06:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-SparkListenerNodeBlacklistedForStage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 163-171行目
- E-02: `core/src/main/scala/org/apache/spark/scheduler/TaskSetExcludeList.scala` 110-168行目
- E-03: `core/src/main/scala/org/apache/spark/scheduler/TaskSetExcludeList.scala` 154-163行目
- E-04: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 68-69行目
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 34行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerNodeBlacklistedForStageはtime, hostId, executorFailures, stageId, stageAttemptIdを持つ | E-01 | ○ |
| C-02 | @deprecated since 3.1.0 | E-01 | ○ |
| C-03 | TaskSetExcludelist.updateExcludedForFailedTask内でExecutor除外後にノード除外判定 | E-02 | ○ |
| C-04 | excludedExecutorsOnNode.size >= MAX_FAILED_EXEC_PER_NODE_STAGEが条件 | E-03 | ○ |
| C-05 | 両イベント（Blacklisted/Excluded）が同時にpostされる | E-03 | ○ |
| C-06 | SparkListenerBus.doPostEventでonNodeBlacklistedForStageにルーティング | E-04 | ○ |
| C-07 | 既にノード除外済みの場合は再イベント発行されない | E-02 | ○ |
| C-08 | ノード除外はExecutor除外を前提条件とする | E-02 | ○ |
| C-09 | hostIdフィールドはExecutor除外のexecutorIdとは異なる | E-01 | ○ |
| C-10 | 通知一覧CSVの情報と一致 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 全主張がソースコードに基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] ノード除外の前提条件（Executor除外）の記述が正確か確認
- [ ] 閾値パラメータ名が正確か確認
