---
generated_at: 2026-02-04 10:12:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-SparkListenerNodeUnblacklisted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 211-213行目
- E-02: `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` 128-143行目
- E-03: `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` 136-137行目
- E-04: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 76-77行目
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 37行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerNodeUnblacklistedはtimeとhostIdのみを持つ | E-01 | ○ |
| C-02 | @deprecated since 3.1.0 | E-01 | ○ |
| C-03 | applyExcludeOnFailureTimeout内でノードのexpiryTime < nowの場合に発火 | E-02 | ○ |
| C-04 | 両イベント（Unblacklisted/Unexcluded）が同時にpostされる | E-03 | ○ |
| C-05 | SparkListenerBus.doPostEventでonNodeUnblacklistedにルーティング | E-04 | ○ |
| C-06 | nodeIdToExcludedExpiryTimeから除去される | E-02 | ○ |
| C-07 | _excludedNodeListが更新される | E-02 | ○ |
| C-08 | Executor解除の後にノード解除処理が行われる | E-02 | ○ |
| C-09 | 通知一覧CSVの情報と一致 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] ノード解除後の_excludedNodeList更新タイミングが正確か確認
- [ ] Executor解除とノード解除の独立性の記述が正確か確認
