---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-SparkListenerSQLExecutionStart

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLListener.scala` 46-66行目
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/execution/SQLExecution.scala` 90-272行目
- E-03: `sql/core/src/main/scala/org/apache/spark/sql/execution/SQLExecution.scala` 153-165行目
- E-04: `sql/core/src/main/scala/org/apache/spark/sql/execution/SQLExecution.scala` 185-186行目
- E-05: `sql/core/src/main/scala/org/apache/spark/sql/execution/SQLExecution.scala` 169行目
- E-06: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusListener.scala` 345-370行目
- E-07: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusListener.scala` 438-439行目
- E-08: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 100行目
- E-09: `sql/core/src/main/scala/org/apache/spark/sql/execution/SQLExecution.scala` 98行目
- E-10: `sql/core/src/main/scala/org/apache/spark/sql/execution/SQLExecution.scala` 128-145行目
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 38行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerSQLExecutionStartは11フィールドを持つcase class | E-01 | ○ |
| C-02 | withNewExecutionId0内で生成される | E-02 | ○ |
| C-03 | 空の計画で初期化され、通常パスではcopyで上書き | E-03, E-04 | ○ |
| C-04 | エラーパスでは空の計画のままpost | E-05 | ○ |
| C-05 | executionIdはAtomicLongから生成 | E-09 | ○ |
| C-06 | rootExecutionIdはネストされたクエリ追跡用 | E-02 | ○ |
| C-07 | descriptionはSQL_EVENT_TRUNCATE_LENGTHで切り詰め | E-10 | ○ |
| C-08 | modifiedConfigsはリダクション済み | E-10 | ○ |
| C-09 | onOtherEvent経由でSQLAppStatusListenerに配信 | E-07, E-08 | ○ |
| C-10 | SQLAppStatusListenerがSparkPlanGraphを構築しKVStoreに書込 | E-06 | ○ |
| C-11 | queryIdはUUID v7形式 | E-02 | ○ |
| C-12 | 初回実行時はqueryExecution.queryIdを使用 | E-02 | ○ |
| C-13 | SparkPlanInfo.EMPTY使用時のフォールバック | E-04 | ○ |
| C-14 | @DeveloperApiアノテーション | E-01 | ○ |
| C-15 | 通知一覧CSVの情報と一致 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 全主張がソースコードに基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] withNewExecutionId0の通常パスとエラーパスの分岐が正確か確認
- [ ] rootExecutionIdの管理ロジックが正確か確認
- [ ] descriptionのリダクション処理が正確か確認
