---
generated_at: 2026-02-04 10:21:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-SparkListenerSQLExecutionEnd

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLListener.scala` 68-96行目
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/execution/SQLExecution.scala` 194-256行目
- E-03: `sql/core/src/main/scala/org/apache/spark/sql/execution/SQLExecution.scala` 226-232行目
- E-04: `sql/core/src/main/scala/org/apache/spark/sql/execution/SQLExecution.scala` 196-201行目
- E-05: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusListener.scala` 401-418行目
- E-06: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusListener.scala` 441行目
- E-07: `sql/core/src/main/scala/org/apache/spark/sql/execution/SQLExecution.scala` 237-241行目
- E-08: `sql/core/src/main/scala/org/apache/spark/sql/execution/SQLExecution.scala` 249行目
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 39行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerSQLExecutionEndはexecutionId, time, errorMessage, queryIdのcase class | E-01 | ○ |
| C-02 | @JsonIgnoreフィールドとしてexecutionName, duration, qe, executionFailure, jobIdsを持つ | E-01 | ○ |
| C-03 | withNewExecutionId0のfinallyブロック内で生成 | E-02 | ○ |
| C-04 | SparkThrowableはPRETTY形式でメッセージ生成 | E-04 | ○ |
| C-05 | その他の例外はUtils.exceptionStringでメッセージ生成 | E-04 | ○ |
| C-06 | errorMessageがSome("")は成功を示す | E-03 | ○ |
| C-07 | executionNameやdurationはイベントpost後に設定 | E-07 | ○ |
| C-08 | dagScheduler.cleanupQueryJobsがpost前に呼ばれる | E-08 | ○ |
| C-09 | onOtherEvent経由でSQLAppStatusListenerに配信 | E-06 | ○ |
| C-10 | SQLAppStatusListenerがkvstore.doAsyncでメトリクス非同期集約 | E-05 | ○ |
| C-11 | completionTimeとerrorMessageが設定される | E-05 | ○ |
| C-12 | endEvents.incrementAndGetで完了イベントカウント更新 | E-05 | ○ |
| C-13 | finallyブロックで必ず発行される | E-02 | ○ |
| C-14 | 通知一覧CSVの情報と一致 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] errorMessageのNone/Some("")/Some(エラー)の使い分けが正確か確認
- [ ] @JsonIgnoreフィールドの設定タイミングが正確か確認
- [ ] シャッフルクリーンアップの実行順序が正確か確認
