---
generated_at: 2026-02-04 10:22:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：39-SparkListenerSQLAdaptiveExecutionUpdate

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **AQEのデフォルト有効バージョン**：Spark 3.2以降のデフォルト有効に関する記述

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLListener.scala` 33-37行目
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/execution/adaptive/AdaptiveSparkPlanExec.scala` 856行目付近
- E-03: `sql/core/src/main/scala/org/apache/spark/sql/execution/adaptive/AdaptiveSparkPlanExec.scala` 48行目
- E-04: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusListener.scala` 372-391行目
- E-05: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusListener.scala` 439行目
- E-06: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 100行目
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 40行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerSQLAdaptiveExecutionUpdateはexecutionId, physicalPlanDescription, sparkPlanInfoを持つ | E-01 | ○ |
| C-02 | AdaptiveSparkPlanExec内でpostされる | E-02 | ○ |
| C-03 | import文でSQLListener内クラスがインポートされている | E-03 | ○ |
| C-04 | onOtherEvent経由でSQLAppStatusListenerに配信 | E-05, E-06 | ○ |
| C-05 | SQLAppStatusListenerがSparkPlanGraphを再構築してKVStoreを更新 | E-04 | ○ |
| C-06 | physicalPlanDescriptionはexplainString由来 | E-02 | ○ |
| C-07 | sparkPlanInfoはSparkPlanInfo.fromSparkPlan由来 | E-02 | ○ |
| C-08 | KVStoreのSparkPlanGraphWrapperが上書きされる | E-04 | ○ |
| C-09 | LiveExecutionDataのphysicalPlanDescriptionとmetricsが更新 | E-04 | ○ |
| C-10 | SparkListenerSQLAdaptiveSQLMetricUpdatesと状況により使い分けされる | E-02 | ○ |
| C-11 | AQEはSpark 3.2以降デフォルト有効 | **根拠なし** | △ |
| C-12 | 通知一覧CSVの情報と一致 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-11: AQEのデフォルト有効化バージョンの記述は一般的な知識に基づいており、本プロジェクトのソースコード内で直接確認していない
  - 候補：`SQLConf.scala`内のADAPTIVE_EXECUTION_ENABLEDのデフォルト値 / Sparkリリースノート / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 1件の根拠不足はバージョン情報に関するものであり、機能的な記述には影響しない

## 6) レビュアーチェックリスト（最小）
- [ ] AQEのデフォルト有効バージョンが正しいか確認（SQLConf.scalaのADAPTIVE_EXECUTION_ENABLEDを参照）
- [ ] AdaptiveSparkPlanExecの行番号が最新コードと一致するか確認
- [ ] SparkListenerSQLAdaptiveSQLMetricUpdatesとの使い分け条件が正確か確認
