---
generated_at: 2026-02-04 10:23:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-SparkListenerSQLAdaptiveSQLMetricUpdates

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLListener.scala` 40-42行目
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/execution/adaptive/AdaptiveSparkPlanExec.scala` 849-853行目
- E-03: `sql/core/src/main/scala/org/apache/spark/sql/execution/adaptive/AdaptiveSparkPlanExec.scala` 850行目
- E-04: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusListener.scala` 393-399行目
- E-05: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusListener.scala` 440行目
- E-06: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 100行目
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 41行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerSQLAdaptiveSQLMetricUpdatesはexecutionIdとsqlPlanMetricsを持つ | E-01 | ○ |
| C-02 | AdaptiveSparkPlanExec内でpostされる | E-02 | ○ |
| C-03 | 新しいサブプランからメトリクスを抽出 | E-03 | ○ |
| C-04 | SQLPlanMetricはname, accumulatorId, metricTypeの3フィールド | E-03 | ○ |
| C-05 | onOtherEvent経由でSQLAppStatusListenerに配信 | E-05, E-06 | ○ |
| C-06 | SQLAppStatusListenerがexec.addMetricsでメトリクスを追加 | E-04 | ○ |
| C-07 | update(exec)でKVStoreを更新 | E-04 | ○ |
| C-08 | 新しいサブプランがある場合に本イベントが発行される | E-02 | ○ |
| C-09 | SparkListenerSQLAdaptiveExecutionUpdateと使い分けされる | E-02 | ○ |
| C-10 | メトリクス差分情報のみを送信する最適化 | E-02 | ○ |
| C-11 | 通知一覧CSVの情報と一致 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] AdaptiveSparkPlanExecの行番号が最新コードと一致するか確認
- [ ] SparkListenerSQLAdaptiveExecutionUpdateとの使い分け条件が正確か確認
- [ ] SQLPlanMetricの構造が正確か確認
