---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：41-SparkListenerDriverAccumUpdates

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **LiveListenerBusのキュー溢れ時の挙動**：具体的な設定値の根拠不足
  2. **イベントログアクセス制御**：セキュリティ考慮事項の具体性不足
  3. **UI上での"driver"表示条件**：aggregateMetrics内の詳細条件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLListener.scala` 106-110行目 - SparkListenerDriverAccumUpdatesケースクラス定義
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLListener.scala` 120-139行目 - LongLongTupleConverterクラス定義
- E-03: `sql/core/src/main/scala/org/apache/spark/sql/execution/metric/SQLMetrics.scala` 201-209行目 - postDriverMetricsUpdatedByValueメソッド
- E-04: `sql/core/src/main/scala/org/apache/spark/sql/execution/metric/SQLMetrics.scala` 215-223行目 - postDriverMetricUpdatesメソッド
- E-05: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusListener.scala` 430-436行目 - onDriverAccumUpdatesメソッド
- E-06: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusListener.scala` 438-445行目 - onOtherEventメソッド
- E-07: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusListener.scala` 278-296行目 - aggregateMetrics内のドライバメトリクス統合処理
- E-08: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusListener.scala` 489-509行目 - LiveExecutionDataクラス定義
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 42行目 - 通知一覧でのSparkListenerDriverAccumUpdatesの定義
- E-10: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLListener.scala` 105行目 - @DeveloperApiアノテーション
- E-11: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLListener.scala` 98-104行目 - Scaladocコメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerDriverAccumUpdatesはexecutionIdとaccumUpdatesを含むケースクラスである | E-01 | ○ |
| C-02 | accumUpdatesはSeq[(Long, Long)]型である | E-01 | ○ |
| C-03 | @DeveloperApiアノテーションが付与されている | E-10 | ○ |
| C-04 | LongLongTupleConverterにより(Int,Int)から(Long,Long)への変換が行われる | E-02 | ○ |
| C-05 | postDriverMetricUpdatesはexecutionIdがnullの場合イベントを送信しない | E-04 | ○ |
| C-06 | postDriverMetricUpdatesはsc.listenerBus.postでイベントを配信する | E-04 | ○ |
| C-07 | postDriverMetricsUpdatedByValueは値を直接指定するバリアントである | E-03 | ○ |
| C-08 | SQLAppStatusListenerがonOtherEventでイベントを受信する | E-06 | ○ |
| C-09 | onDriverAccumUpdatesでdriverAccumUpdatesに追記される | E-05 | ○ |
| C-10 | aggregateMetricsでドライバメトリクスとタスクメトリクスが統合される | E-07 | ○ |
| C-11 | ドライバ値がタスクのmax値より大きい場合maxMetricsFromAllStagesからエントリが削除される | E-07 | ○ |
| C-12 | LiveExecutionDataにdriverAccumUpdatesフィールドがある | E-08 | ○ |
| C-13 | イベントはLiveListenerBus経由で非同期配信される | E-04, E-06 | ○ |
| C-14 | @JsonDeserialize(contentConverter)がaccumUpdatesに付与されている | E-01 | ○ |
| C-15 | ドライバ側メトリクスはサブクエリ実行時間やファイル数等を含む | E-11 | ○ |
| C-16 | SPARK-18462対応でLongLongTupleConverterが導入された | E-02 | ○ |
| C-17 | liveExecutionsにexecutionIdが存在しない場合は安全にスキップされる | E-05 | ○ |
| C-18 | LiveListenerBusのキュー溢れ時にイベントがドロップされる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: LiveListenerBusのキュー溢れ時の挙動について、SQLAppStatusListener.scalaやSQLListener.scala内に明示的な記述がない。一般的なLiveListenerBusの仕様に基づく推測である。
  - 候補：LiveListenerBus.scala / SparkConf内のspark.scheduler.listenerbus.eventqueue.capacity設定 / Sparkドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベント構造やリスナー処理の記述は全てソースコードから検証済み
- 1: 中リスク - キュー溢れ時の挙動は一般的なLiveListenerBusの仕様に基づく推測であり、バージョンによって変わる可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] SparkListenerDriverAccumUpdatesのイベント構造記述が実装と一致しているか
- [ ] postDriverMetricUpdatesのnullチェック条件が正確か
- [ ] SQLAppStatusListenerのonDriverAccumUpdates処理フローが実装と一致しているか
- [ ] aggregateMetrics内のドライバメトリクス統合ロジックの記述が正確か
- [ ] LiveListenerBusのキュー溢れ時の挙動記述を確認（推測部分）
