---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-SparkListenerSpeculativeTaskSubmitted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 該当なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` L47-64（ケースクラス定義、プライベートフィールド、補助コンストラクタ）
- E-02: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` L1296-1299（handleSpeculativeTaskSubmitted）
- E-03: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` L92-93（doPostEventのSpeculativeTaskSubmittedパターンマッチ）
- E-04: `core/src/main/scala/org/apache/spark/ExecutorAllocationManager.scala` L829-832（onSpeculativeTaskSubmittedハンドラ）
- E-05: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` L482-484（onSpeculativeTaskSubmitted定義）
- E-06: `core/src/main/scala/org/apache/spark/deploy/history/BasicEventFilterBuilder.scala` L131-132（イベントフィルタリング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 主コンストラクタはstageId, stageAttemptIdの2引数 | E-01 | ○ |
| C-02 | _taskIndexと_partitionIdはプライベートvarフィールド | E-01 | ○ |
| C-03 | 4引数の補助コンストラクタが存在する | E-01 | ○ |
| C-04 | 後方互換性のための特殊設計（taskIndexがケースクラス引数ではない） | E-01 | ○ |
| C-05 | stageAttemptIdのデフォルト値は0 | E-01 | ○ |
| C-06 | DAGSchedulerからは4引数の補助コンストラクタで生成される | E-02 | ○ |
| C-07 | handleSpeculativeTaskSubmitted（L1296-1299）でイベントが発火 | E-02 | ○ |
| C-08 | SparkListenerBusでパターンマッチによりonSpeculativeTaskSubmittedが呼ばれる | E-03 | ○ |
| C-09 | ExecutorAllocationManagerがonSpeculativeTaskSubmittedを受信する | E-04 | ○ |
| C-10 | 投機的タスクの追加によるExecutor要求数の再計算が行われる | E-04 | ○ |
| C-11 | SparkListenerInterfaceにonSpeculativeTaskSubmittedが定義されている | E-05 | ○ |
| C-12 | 履歴サーバーのイベントフィルタでliveStagesに基づくフィルタリングが行われる | E-06 | ○ |
| C-13 | SparkListenerEventを継承している | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードの根拠と一致

## 6) レビュアーチェックリスト（最小）
- [ ] SparkListenerSpeculativeTaskSubmittedの特殊なコンストラクタ設計が正確に記述されているか
- [ ] DAGScheduler.handleSpeculativeTaskSubmittedの行番号が最新コードと一致しているか
- [ ] ExecutorAllocationManagerの投機的タスク処理が正確に記述されているか
