---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：57-CreateFunctionEvent

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **C-13: CREATE FUNCTION SQL経由の呼び出し**：具体的なコードパスは未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` 行168（CreateFunctionEvent定義）
- E-02: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` 行153-158（FunctionEventトレイト）
- E-03: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` 行285-290（createFunctionメソッド）
- E-04: `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` 行176-182（テスト）
- E-05: `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` 行175（ブリッジ）
- E-06: `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` 行37-69（ListenerBus）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateFunctionEventは関数作成完了後に発火する | E-01, E-03 | ○ |
| C-02 | database, nameの2フィールドを持つcase class | E-01 | ○ |
| C-03 | 行289でデリゲート処理成功後にpostToAll | E-03 | ○ |
| C-04 | 同名関数存在時はCreateFunctionEventは未発火 | E-04 | ○ |
| C-05 | 関数名はfuncDefinition.identifier.funcNameから取得 | E-03 | ○ |
| C-06 | 同期配信（postToAll） | E-03, E-06 | ○ |
| C-07 | SharedState経由でlistenerBusに伝播 | E-05 | ○ |
| C-08 | CreateFunctionPreEvent（No.56）が対応するPreイベント | E-03 | ○ |
| C-09 | FunctionEventトレイトを継承 | E-01, E-02 | ○ |
| C-10 | 関数のclassNameはイベントに含まれない | E-01 | ○ |
| C-11 | リスナー例外はListenerBusでキャッチ | E-06 | ○ |
| C-12 | デリゲート先で関数メタデータをINSERT | E-03 | ○ |
| C-13 | CREATE FUNCTION SQL文経由で呼ばれる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: SQL文からcreateFunctionメソッドへの呼び出しパスは推定
  - 候補：`CreateFunctionCommand` / SessionCatalog

## 5) リスクフラグ（レビュー観点）
- 0: CreateFunctionEventのデータ構造（ソースコードから直接確認済み）
- 0: イベント発火タイミング（ソースコードおよびテストコードで確認済み）
- 1: SQL経由の呼び出しパス（推定ベース）

## 6) レビュアーチェックリスト（最小）
- [ ] CreateFunctionEventのフィールドがソースコードと一致しているか確認
- [ ] createFunctionメソッドの行番号が最新ソースと一致しているか確認
- [ ] CREATE FUNCTION SQL文からの呼び出しパスを確認
