---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：61-AlterFunctionEvent

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **EventLoggingListenerによるJSON記録**：根拠不足（コード確認が不十分）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` 188行目
- E-02: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` 150-158行目
- E-03: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` 26行目
- E-04: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` 298-303行目
- E-05: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` 34-38行目
- E-06: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` 27-29行目
- E-07: `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` 149-178行目
- E-08: `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` 194-201行目
- E-09: `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` 69-72行目
- E-10: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` 180-188行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AlterFunctionEventはcase classとしてdatabase, nameフィールドを持つ | E-01 | ○ |
| C-02 | FunctionEventトレイトを継承しdatabase, nameを定義 | E-02 | ○ |
| C-03 | ExternalCatalogEventはSparkListenerEventを継承する | E-03 | ○ |
| C-04 | alterFunction()内でPreEvent発火後にdelegate呼び出し、成功後にPostEvent発火 | E-04 | ○ |
| C-05 | doPostEvent()でlistener.onEvent(event)を呼び出す | E-05 | ○ |
| C-06 | ListenerBusトレイトをミックスインしpostToAll()で配信する | E-06 | ○ |
| C-07 | SharedState内でExternalCatalogWithListenerを生成しlistenerBusへの転送リスナーを登録 | E-07 | ○ |
| C-08 | デリゲート先で例外発生時はPostEventが発火されない | E-09 | ○ |
| C-09 | テストでalterFunction()時にPre/Postイベントペアが検証されている | E-08 | ○ |
| C-10 | AlterFunctionPreEventとペアで使用される | E-10, E-04 | ○ |
| C-11 | 送信方式は同期（ListenerBus.postToAll） | E-06 | ○ |
| C-12 | リトライ機構は存在しない | E-04, E-06 | ○ |
| C-13 | レート制限は存在しない | E-04, E-06 | ○ |
| C-14 | 関数名はCatalogFunction.identifier.funcNameから取得される | E-04 | ○ |
| C-15 | EventLoggingListenerが有効な場合イベントログにJSON形式で記録される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15のEventLoggingListenerによるJSON記録について、SparkListenerEventを継承しているため理論的にはイベントログに記録されるが、ExternalCatalogEventが実際にJSON化されるかの直接的なコード確認が不十分
  - 候補：EventLoggingListener.scala / JsonProtocol.scala / SparkListenerEvent定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - AlterFunctionEventの基本的な構造と動作は全てソースコードで確認済み
- 1: 中リスク - イベントログへの記録に関する記述は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] AlterFunctionEventのフィールド（database, name）が正しいか確認
- [ ] alterFunction()のPre/Post発火順序が正しいか確認
- [ ] SharedStateでのlistenerBus転送が正しく記述されているか確認
- [ ] EventLoggingListenerでのJSON記録について追加確認が必要か判断
