---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-SparkListenerJobStart

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 該当なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` L79-88（SparkListenerJobStartケースクラス定義）
- E-02: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` L1443-1445（handleJobSubmittedでのpost）
- E-03: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` L1490-1492（handleMapStageSubmittedでのpost）
- E-04: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` L973-974（submitJob空パーティションパス）
- E-05: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` L1054（runApproximateJob空パーティションパス）
- E-06: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` L36-37（doPostEventのJobStartパターンマッチ）
- E-07: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` L335-336（onJobStart定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerJobStartは4フィールドのケースクラス | E-01 | ○ |
| C-02 | stageIdsは派生valフィールド（stageInfos.map(_.stageId)） | E-01 | ○ |
| C-03 | propertiesのデフォルト値はnull | E-01 | ○ |
| C-04 | handleJobSubmitted（L1443-1445）でイベントが発火 | E-02 | ○ |
| C-05 | handleMapStageSubmitted（L1490-1492）でイベントが発火 | E-03 | ○ |
| C-06 | submitJob空パーティション（L973-974）でイベントが発火 | E-04 | ○ |
| C-07 | runApproximateJob空パーティション（L1054）でイベントが発火 | E-05 | ○ |
| C-08 | 空パーティション時にJobStartとJobEndが連続postされる | E-04, E-05 | ○ |
| C-09 | SparkListenerBusでパターンマッチによりonJobStartが呼ばれる | E-06 | ○ |
| C-10 | propertiesはUtils.clonePropertiesでクローンされる | E-02, E-03 | ○ |
| C-11 | stageInfosはstageIdToStageから収集される | E-02 | ○ |
| C-12 | timeはclock.getTimeMillis()で取得される | E-02 | ○ |
| C-13 | jobIdはnextJobId.getAndIncrement()で生成される | E-04 | ○ |
| C-14 | 後方互換性のためstageIdsフィールドが残されている | E-01 | ○ |
| C-15 | SparkListenerEventを継承している | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードの根拠と一致

## 6) レビュアーチェックリスト（最小）
- [ ] SparkListenerJobStartの4+1フィールド定義がソースコードと一致しているか
- [ ] 4つの発火箇所の行番号が最新コードと一致しているか
- [ ] 空パーティション時のJobStart+JobEnd連続postの動作が正確か
