---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：72-QueryStartedEvent

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/api/src/main/scala/org/apache/spark/sql/streaming/StreamingQueryListener.scala` 164-186行目（QueryStartedEvent定義）
- E-02: `sql/api/src/main/scala/org/apache/spark/sql/streaming/StreamingQueryListener.scala` 147行目（Event trait定義）
- E-03: `sql/api/src/main/scala/org/apache/spark/sql/streaming/StreamingQueryListener.scala` 49-56行目（onQueryStartedの同期配信コメント）
- E-04: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/StreamExecution.scala` 258-302行目（runStreamでのイベント発火）
- E-05: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/StreamingQueryListenerBus.scala` 71-81行目（postメソッド）
- E-06: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/StreamingQueryListenerBus.scala` 118-147行目（doPostEvent）
- E-07: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/StreamingQueryListenerBus.scala` 63行目（activeQueryRunIds）
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 73行目（通知No.72定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QueryStartedEventはストリーミングクエリ開始時に発火 | E-03, E-04 | ○ |
| C-02 | id, runId, name, timestamp, jobTagsの5フィールドを持つ | E-01 | ○ |
| C-03 | onQueryStartedは同期的に呼ばれstart()の前に完了する | E-03 | ○ |
| C-04 | StreamingQueryListener.Eventを継承しSparkListenerEventも継承 | E-01, E-02 | ○ |
| C-05 | StreamExecution.runStream内でpostEventが呼ばれる | E-04 | ○ |
| C-06 | StreamingQueryListenerBus.postでactiveQueryRunIdsに追加される | E-05, E-07 | ○ |
| C-07 | QueryStartedEventのみローカルpostToAllで同期配信 | E-05（73-77行目） | ○ |
| C-08 | sparkListenerBusにも非同期ポストされる | E-05（75行目） | ○ |
| C-09 | nameはnull許容 | E-01（167行目: val name: String）, E-03コメント | ○ |
| C-10 | jobTagsなしの後方互換コンストラクタを持つ | E-01（173-175行目） | ○ |
| C-11 | jsonメソッドでJSON形式にシリアライズ可能 | E-01（177行目） | ○ |
| C-12 | fromJsonメソッドでデシリアライズ可能 | E-01（188-199行目 companion object） | ○ |
| C-13 | doPostEventでlistener.onQueryStartedが呼ばれる | E-06（129-131行目） | ○ |
| C-14 | Since 2.1.0で導入 | E-01（162行目 @since 2.1.0） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な内容のみで構成

## 6) レビュアーチェックリスト（最小）
- [ ] QueryStartedEventの同期配信メカニズムが正確に記述されているか確認
- [ ] フィールドの型とnull許容性が正確か確認
- [ ] StreamExecution内のイベント発火タイミングが正確か確認
