---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：73-QueryProgressEvent

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/api/src/main/scala/org/apache/spark/sql/streaming/StreamingQueryListener.scala` 208-215行目（QueryProgressEvent定義）
- E-02: `sql/api/src/main/scala/org/apache/spark/sql/streaming/StreamingQueryListener.scala` 60-68行目（onQueryProgressのJavadoc）
- E-03: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/ProgressReporter.scala` 93-100行目（updateProgress）
- E-04: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/ProgressReporter.scala` 130-132行目（postEvent）
- E-05: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/StreamingQueryListenerBus.scala` 78-79行目（非同期配信）
- E-06: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/StreamingQueryListenerBus.scala` 133-135行目（doPostEvent内onQueryProgress）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 74行目（通知No.73定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QueryProgressEventはバッチ処理完了時に発火 | E-02, E-03 | ○ |
| C-02 | StreamingQueryProgressオブジェクトを内包 | E-01（val progress: StreamingQueryProgress） | ○ |
| C-03 | 非同期配信である | E-02（Javadocに明記）, E-05 | ○ |
| C-04 | ProgressReporter.updateProgressで発火 | E-03（98行目） | ○ |
| C-05 | progressBufferに追加される | E-03（97行目） | ○ |
| C-06 | postEventでStreamingQueryListenerBusに配信 | E-04 | ○ |
| C-07 | SparkListenerBus経由で非同期配信 | E-05 | ○ |
| C-08 | doPostEventでshouldReportチェック後に配信 | E-06 | ○ |
| C-09 | json/fromJsonメソッドを持つ | E-01（212行目）, StreamingQueryListener.scala 217-223行目 | ○ |
| C-10 | Since 2.1.0で導入 | E-01（207行目 @since 2.1.0） | ○ |
| C-11 | Event traitを継承 | E-01 | ○ |
| C-12 | lastNoExecutionProgressEventTimeが更新される | E-03（95行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な内容のみで構成

## 6) レビュアーチェックリスト（最小）
- [ ] 非同期配信のメカニズムが正確に記述されているか確認
- [ ] StreamingQueryProgressの含まれるフィールドが網羅的か確認
- [ ] イベント発火元のProgressReporterの処理フローが正確か確認
