---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：74-QueryIdleEvent

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/api/src/main/scala/org/apache/spark/sql/streaming/StreamingQueryListener.scala` 237-248行目（QueryIdleEvent定義）
- E-02: `sql/api/src/main/scala/org/apache/spark/sql/streaming/StreamingQueryListener.scala` 74行目（onQueryIdleデフォルト実装）
- E-03: `sql/api/src/main/scala/org/apache/spark/sql/streaming/StreamingQueryListener.scala` 225-235行目（QueryIdleEvent Javadoc）
- E-04: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/ProgressReporter.scala` 112-128行目（updateIdleness）
- E-05: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/ProgressReporter.scala` 62行目（lastNoExecutionProgressEventTime初期値Long.MinValue）
- E-06: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/ProgressReporter.scala` 69-70行目（noDataProgressEventInterval設定）
- E-07: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/StreamingQueryListenerBus.scala` 137-139行目（doPostEvent内onQueryIdle）
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 75行目（通知No.74定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QueryIdleEventはアイドル状態時に発火 | E-03, E-04 | ○ |
| C-02 | Since 3.5.0で導入 | E-03（@since 3.5.0） | ○ |
| C-03 | id, runId, timestampの3フィールドを持つ | E-01 | ○ |
| C-04 | onQueryIdleにはデフォルト実装（空メソッド）がある | E-02 | ○ |
| C-05 | updateIdlenessメソッドで発火 | E-04 | ○ |
| C-06 | noDataProgressEventInterval経過後に発火 | E-04（118行目）, E-06 | ○ |
| C-07 | 初回判定時はイベント発火されない | E-04（120行目）, E-05 | ○ |
| C-08 | lastNoExecutionProgressEventTimeの初期値はLong.MinValue | E-05 | ○ |
| C-09 | addNewProgressでprogressBufferに追加 | E-04（119行目） | ○ |
| C-10 | formatTimestampでISO8601形式に変換 | E-04（121行目）, ProgressReporter.formatTimestamp | ○ |
| C-11 | 非同期配信される | E-07, StreamingQueryListenerBus.post | ○ |
| C-12 | shouldReportチェックでrunIdが確認される | E-07 | ○ |
| C-13 | json/fromJsonメソッドを持つ | E-01（242行目）, StreamingQueryListener.scala 250-258行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な内容のみで構成

## 6) レビュアーチェックリスト（最小）
- [ ] updateIdlenessの発火条件ロジック（間隔チェック+初回判定チェック）が正確か確認
- [ ] noDataProgressEventIntervalのデフォルト値が正確か確認
- [ ] 初回判定の抑止メカニズムが正確に記述されているか確認
