---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：75-QueryTerminatedEvent

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/api/src/main/scala/org/apache/spark/sql/streaming/StreamingQueryListener.scala` 278-298行目（QueryTerminatedEvent定義）
- E-02: `sql/api/src/main/scala/org/apache/spark/sql/streaming/StreamingQueryListener.scala` 261-276行目（Javadoc）
- E-03: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/StreamExecution.scala` 425-428行目（イベント発火）
- E-04: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/StreamExecution.scala` 277-280行目（保証コメント）
- E-05: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/StreamingQueryListenerBus.scala` 87-94行目（postToAllオーバーライド）
- E-06: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/StreamingQueryListenerBus.scala` 141-143行目（doPostEvent内onQueryTerminated）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 76行目（通知No.75定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QueryTerminatedEventはクエリ終了時に発火 | E-02, E-03 | ○ |
| C-02 | id, runId, exception, errorClassOnExceptionの4フィールドを持つ | E-01 | ○ |
| C-03 | exceptionとerrorClassOnExceptionはOption[String]型 | E-01（281-282行目） | ○ |
| C-04 | 正常終了時はexception=None | E-02 | ○ |
| C-05 | runStreamのfinally句で発火 | E-03 | ○ |
| C-06 | notifyQueryTermination後にpostEventが呼ばれる | E-03（425-428行目） | ○ |
| C-07 | 配信完了後にactiveQueryRunIdsからrunIdが除去される | E-05 | ○ |
| C-08 | SPARK-19594対応でpostToAllがオーバーライドされている | E-05（85行目コメント） | ○ |
| C-09 | doPostEventでlistener.onQueryTerminatedが呼ばれる | E-06 | ○ |
| C-10 | Since 2.1.0で導入 | E-02（@since 2.1.0） | ○ |
| C-11 | 後方互換コンストラクタを持つ | E-01（286-288行目） | ○ |
| C-12 | QueryStartedEventの後にQueryTerminatedEventが保証される | E-04 | ○ |
| C-13 | 非同期配信である | E-05（sparkListenerBus経由）, StreamingQueryListenerBus.post | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な内容のみで構成

## 6) レビュアーチェックリスト（最小）
- [ ] QueryTerminatedEventのフィールド型と意味が正確か確認
- [ ] activeQueryRunIds除去のタイミングが正確か確認
- [ ] Start-Terminatedの保証メカニズムが正確に記述されているか確認
