---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：76-StreamingListenerStreamingStarted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 33行目（イベント定義）
- E-02: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 30行目（sealed trait定義）
- E-03: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 73行目（onStreamingStarted）
- E-04: `streaming/src/main/scala/org/apache/spark/streaming/StreamingContext.scala` 598-599行目（イベント発火）
- E-05: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` 36-38行目（post）
- E-06: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` 40-46行目（onOtherEvent）
- E-07: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` 68-69行目（doPostEvent）
- E-08: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` 94-100行目（WrappedStreamingListenerEvent、logEvent=false）
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 77行目（通知No.76定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StreamingListenerStreamingStartedはStreaming処理開始時に発火 | E-04 | ○ |
| C-02 | timeフィールド（Long型）のみを持つ | E-01 | ○ |
| C-03 | StreamingListenerEvent sealed traitを継承 | E-01, E-02 | ○ |
| C-04 | @DeveloperApiアノテーション付き | E-01（32行目） | ○ |
| C-05 | StreamingContext.start()内でstate=ACTIVE後に発火 | E-04 | ○ |
| C-06 | System.currentTimeMillis()がtimeに設定される | E-04（599行目） | ○ |
| C-07 | WrappedStreamingListenerEventにラップされる | E-05 | ○ |
| C-08 | onOtherEventでアンラップされてpostToAllされる | E-06 | ○ |
| C-09 | doPostEventでlistener.onStreamingStartedが呼ばれる | E-07 | ○ |
| C-10 | onStreamingStartedにはデフォルト実装（空メソッド）がある | E-03 | ○ |
| C-11 | logEvent=falseのためイベントログに記録されない | E-08 | ○ |
| C-12 | JobScheduler.listenerBusから配信される | E-04, JobScheduler.scala 57行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な内容のみで構成

## 6) レビュアーチェックリスト（最小）
- [ ] イベント発火タイミング（state=ACTIVE後）が正確か確認
- [ ] WrappedStreamingListenerEventのラップ・アンラップメカニズムが正確か確認
- [ ] logEvent=falseの影響が正確に記述されているか確認
