---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：77-StreamingListenerBatchSubmitted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 36行目（イベント定義）
- E-02: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 85行目（onBatchSubmitted）
- E-03: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/BatchInfo.scala` 35-42行目（BatchInfo定義）
- E-04: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/JobScheduler.scala` 145-154行目（submitJobSet）
- E-05: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` 58-59行目（doPostEvent）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 78行目（通知No.77定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StreamingListenerBatchSubmittedはバッチ送信時に発火 | E-04（149行目） | ○ |
| C-02 | batchInfo: BatchInfoフィールドを持つ | E-01 | ○ |
| C-03 | jobSet.jobs.isEmptyの場合はイベント未発火 | E-04（146行目） | ○ |
| C-04 | ジョブ実行キュー投入前に発火 | E-04（149-151行目の順序） | ○ |
| C-05 | BatchInfoにはbatchTime, submissionTime等が含まれる | E-03 | ○ |
| C-06 | 送信時点ではprocessingStartTime/EndTimeはNone | E-03, E-04（toBatchInfoの時点） | ○ |
| C-07 | onBatchSubmittedにはデフォルト実装（空メソッド）がある | E-02 | ○ |
| C-08 | @DeveloperApiアノテーション付き | E-01（35行目） | ○ |
| C-09 | doPostEventでlistener.onBatchSubmittedが呼ばれる | E-05 | ○ |
| C-10 | BatchInfoのnumRecordsは入力レコード数の合計 | E-03（68行目） | ○ |
| C-11 | WrappedStreamingListenerEventはlogEvent=false | StreamingListenerBus.scala 99行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な内容のみで構成

## 6) レビュアーチェックリスト（最小）
- [ ] submitJobSetの発火タイミング（ジョブ投入前）が正確か確認
- [ ] 空ジョブセットの抑止条件が正確か確認
- [ ] BatchInfoの各フィールドの意味が正確か確認
