---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：78-StreamingListenerBatchStarted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 42行目（イベント定義）
- E-02: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 88行目（onBatchStarted）
- E-03: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/JobScheduler.scala` 181-194行目（handleJobStart）
- E-04: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/JobScheduler.scala` 183行目（isFirstJobOfJobSet判定）
- E-05: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/JobScheduler.scala` 186-188行目（コメント：handleJobStart後にprocessingStartTime取得）
- E-06: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` 60-61行目（doPostEvent）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 79行目（通知No.78定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StreamingListenerBatchStartedはバッチの最初のジョブ開始時に発火 | E-03, E-04 | ○ |
| C-02 | batchInfo: BatchInfoフィールドを持つ | E-01 | ○ |
| C-03 | isFirstJobOfJobSetは!jobSet.hasStartedで判定 | E-04 | ○ |
| C-04 | handleJobStart呼び出し後にイベントが送信される | E-05 | ○ |
| C-05 | processingStartTimeが設定済み | E-05, E-03 | ○ |
| C-06 | processingEndTimeはNone | E-03（開始時点の状態） | ○ |
| C-07 | バッチ内の2番目以降のジョブでは発火しない | E-03, E-04（条件分岐） | ○ |
| C-08 | onBatchStartedにはデフォルト実装がある | E-02 | ○ |
| C-09 | schedulingDelayが計算可能 | BatchInfo.scala 49行目 | ○ |
| C-10 | doPostEventでlistener.onBatchStartedが呼ばれる | E-06 | ○ |
| C-11 | 非同期配信される | StreamingListenerBus.post, WrappedStreamingListenerEvent | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な内容のみで構成

## 6) レビュアーチェックリスト（最小）
- [ ] isFirstJobOfJobSetの判定ロジックが正確か確認
- [ ] handleJobStart後にイベント発火される順序が正確か確認
- [ ] BatchInfoの各フィールドの設定状態（Start時点）が正確か確認
