---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：79-StreamingListenerBatchCompleted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 39行目（イベント定義）
- E-02: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 91行目（onBatchCompleted）
- E-03: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/BatchInfo.scala` 35-42行目（BatchInfo定義）
- E-04: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/BatchInfo.scala` 49-63行目（計算プロパティ）
- E-05: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/JobScheduler.scala` 196-219行目（handleJobCompletion）
- E-06: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` 62-63行目（doPostEvent）
- E-07: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 109-132行目（StatsReportListener）
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 80行目（通知No.79定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StreamingListenerBatchCompletedはバッチの全ジョブ完了時に発火 | E-05（203行目） | ○ |
| C-02 | batchInfo: BatchInfoフィールドを持つ | E-01 | ○ |
| C-03 | jobSet.hasCompletedで全ジョブ完了を判定 | E-05（203行目） | ○ |
| C-04 | processingStartTimeとprocessingEndTimeが共に設定済み | E-05（処理順序） | ○ |
| C-05 | schedulingDelay, processingDelay, totalDelayが計算可能 | E-04 | ○ |
| C-06 | バッチ完了後にjobSetsから削除される | E-05（211行目） | ○ |
| C-07 | jobGenerator.onBatchCompletionが呼ばれる | E-05（212行目） | ○ |
| C-08 | ジョブ失敗時もBatchCompletedが発火される | E-05（203-206行目、条件分岐） | ○ |
| C-09 | onBatchCompletedにはデフォルト実装がある | E-02 | ○ |
| C-10 | doPostEventでlistener.onBatchCompletedが呼ばれる | E-06 | ○ |
| C-11 | StatsReportListenerがBatchCompletedをリッスンする | E-07（113行目） | ○ |
| C-12 | RateControllerがレート調整に利用する | JobScheduler.scala 81-84行目（rateControllerの登録） | ○ |
| C-13 | numRecordsは入力レコード数の合計 | E-03（68行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な内容のみで構成

## 6) レビュアーチェックリスト（最小）
- [ ] handleJobCompletionの全ジョブ完了判定ロジックが正確か確認
- [ ] ジョブ失敗時の挙動が正確に記述されているか確認
- [ ] BatchInfoの計算プロパティが全て利用可能か確認
