---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：80-StreamingListenerOutputOperationStarted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 45-46行目（イベント定義）
- E-02: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 94-95行目（onOutputOperationStarted）
- E-03: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/OutputOperationInfo.scala` 35-42行目（OutputOperationInfo定義）
- E-04: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/OutputOperationInfo.scala` 47行目（duration計算）
- E-05: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/JobScheduler.scala` 190-191行目（イベント発火）
- E-06: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/JobScheduler.scala` 181-194行目（handleJobStart全体）
- E-07: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` 64-65行目（doPostEvent）
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 81行目（通知No.80定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StreamingListenerOutputOperationStartedは出力操作開始時に発火 | E-05, E-06 | ○ |
| C-02 | outputOperationInfo: OutputOperationInfoフィールドを持つ | E-01 | ○ |
| C-03 | OutputOperationInfoはbatchTime, id, name, description, startTime, endTime, failureReasonを持つ | E-03 | ○ |
| C-04 | handleJobStart内でjob.setStartTime後に発火 | E-05, E-06（190-191行目） | ○ |
| C-05 | BatchStartedイベントの後に発火される | E-06（188行目と191行目の順序） | ○ |
| C-06 | 各ジョブの開始時にそれぞれ発火（バッチの最初のジョブに限らない） | E-06（条件分岐外の191行目） | ○ |
| C-07 | 開始時点ではendTimeはNone | E-03（startTimeのみ設定される） | ○ |
| C-08 | 開始時点ではfailureReasonはNone | E-03 | ○ |
| C-09 | durationはstartTimeとendTimeの差分で計算 | E-04 | ○ |
| C-10 | onOutputOperationStartedにはデフォルト実装がある | E-02 | ○ |
| C-11 | doPostEventでlistener.onOutputOperationStartedが呼ばれる | E-07 | ○ |
| C-12 | @DeveloperApiアノテーション付き | E-01（44行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な内容のみで構成

## 6) レビュアーチェックリスト（最小）
- [ ] handleJobStart内での発火タイミング（BatchStarted後、各ジョブ個別）が正確か確認
- [ ] OutputOperationInfoの各フィールドの設定状態（Start時点）が正確か確認
- [ ] job.toOutputOperationInfoの変換ロジックが正確か確認
