---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：81-StreamingListenerOutputOperationCompleted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **イベントログへの記録仕様の詳細**：logEventプロパティの効果範囲の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 行48-50
- E-02: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/JobScheduler.scala` 行196-200
- E-03: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` 行36-38, 48-67
- E-04: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/OutputOperationInfo.scala` 行35-48
- E-05: `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` 行131-136
- E-06: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` 行94-100
- E-07: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 行97-99
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行82

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StreamingListenerOutputOperationCompletedはStreamingListenerEventを継承するケースクラスである | E-01 | ○ |
| C-02 | イベントはOutputOperationInfoを保持する | E-01 | ○ |
| C-03 | JobScheduler.handleJobCompletionで発火される | E-02 | ○ |
| C-04 | job.setEndTime後にlistenerBus.postされる | E-02 | ○ |
| C-05 | StreamingListenerBusはWrappedStreamingListenerEventにラップして配信する | E-03 | ○ |
| C-06 | doPostEventでonOutputOperationCompletedが呼ばれる | E-03 | ○ |
| C-07 | OutputOperationInfoはbatchTime, id, name, description, startTime, endTime, failureReasonを含む | E-04 | ○ |
| C-08 | StreamingJobProgressListenerがrunningBatchUIDataを更新する | E-05 | ○ |
| C-09 | LiveListenerBusのSTATUS_QUEUEに登録される | E-03 (行79: sparkListenerBus.addToStatusQueue) | ○ |
| C-10 | logEventプロパティはfalseに設定されている | E-06 | ○ |
| C-11 | StreamingListenerトレイトのonOutputOperationCompletedメソッドはデフォルト空実装 | E-07 | ○ |
| C-12 | 本イベントはonBatchCompletedの前に発火される | E-02 (行200, 203-204の順序) | ○ |
| C-13 | ジョブ完了はJobHandler.runからEventLoop経由でhandleJobCompletionに伝播する | E-02 (行230, 261) | ○ |
| C-14 | イベント配信はリトライなしでドロップされる | E-03 | ○ |
| C-15 | メール通知として配信される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15に関して、本イベントがメール通知ではなくプログラム内イベントである旨は設計書に記載済みだが、テンプレートの「メール通知の場合」セクションが「該当なし」であることの根拠を明示的に示すソースコードはない
  - 候補：Sparkドキュメント / StreamingListenerの公式API文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードとの整合性が高い
- 0: 低リスク - イベントの発火順序はソースコードから明確に読み取れる
- 1: 中リスク - イベントログ非記録の仕様はSPARK-12140に依存しており、将来変更の可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] OutputOperationInfoのフィールドがソースコードと一致しているか確認
- [ ] handleJobCompletionの処理順序が正しく記述されているか確認
- [ ] StreamingListenerBusの配信メカニズムの説明が正確か確認
