---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：82-StreamingListenerReceiverStarted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 行52-54
- E-02: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverInfo.scala` 行27-37
- E-03: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverTracker.scala` 行264-314
- E-04: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverTracker.scala` 行300
- E-05: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` 行52-53
- E-06: `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` 行75-79
- E-07: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverTracker.scala` 行515-520
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行83

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StreamingListenerReceiverStartedはReceiverInfoを保持するケースクラス | E-01 | ○ |
| C-02 | ReceiverInfoはstreamId, name, active, location, executorId等のフィールドを持つ | E-02 | ○ |
| C-03 | ReceiverTracker.registerReceiverメソッドで発火される | E-03 | ○ |
| C-04 | レシーバー名は${typ}-${streamId}の形式 | E-04 | ○ |
| C-05 | isAcceptable判定でExecutor/ホスト一致を確認する | E-03 (行291-294) | ○ |
| C-06 | ReceiverTrackingInfoをACTIVE状態で更新後にイベント発火 | E-03 (行301-309) | ○ |
| C-07 | StreamingListenerBus.doPostEventでonReceiverStartedが呼ばれる | E-05 | ○ |
| C-08 | StreamingJobProgressListenerがreceiverInfosを更新する | E-06 | ○ |
| C-09 | RegisterReceiverメッセージはreceiveAndReplyで処理される | E-07 | ○ |
| C-10 | ReceiverTracker停止中は登録を拒否する | E-03 (行276-278) | ○ |
| C-11 | 未知のstreamIdでSparkExceptionがスローされる | E-03 (行272-273) | ○ |
| C-12 | 配信はLiveListenerBus経由で非同期 | E-05 | ○ |
| C-13 | logEventはfalseでイベントログ非記録 | E-05 (StreamingListenerBus.scala 行94-100) | ○ |
| C-14 | 登録成功時にBoolean trueが呼び出し元に返却される | E-03 (行313) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり
- 0: 低リスク - イベントの発火条件が明確

## 6) レビュアーチェックリスト（最小）
- [ ] ReceiverInfoのフィールドがソースコードと一致しているか確認
- [ ] registerReceiverの処理フローが正しく記述されているか確認
- [ ] isAcceptable判定ロジックの説明が正確か確認
