---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：83-StreamingListenerReceiverError

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 行56-58
- E-02: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverInfo.scala` 行27-37
- E-03: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverTracker.scala` 行354-377
- E-04: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverTracker.scala` 行511-512
- E-05: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` 行54-55
- E-06: `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` 行81-84
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行84

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StreamingListenerReceiverErrorはReceiverInfoを保持するケースクラス | E-01 | ○ |
| C-02 | ReceiverTracker.reportErrorメソッドで発火される | E-03 | ○ |
| C-03 | ReportErrorはreceiveメソッド（非同期）で処理される | E-04 | ○ |
| C-04 | 既存ReceiverTrackingInfoがある場合はcopyでerrorInfoを更新 | E-03 (行355-358) | ○ |
| C-05 | 既存情報がない場合はINACTIVE状態で新規作成 | E-03 (行360-365) | ○ |
| C-06 | lastErrorTimeは既存情報がある場合は以前の値を引き継ぐ | E-03 (行358) | ○ |
| C-07 | receiverTrackingInfos更新後にlistenerBus.postが呼ばれる | E-03 (行368-369) | ○ |
| C-08 | StreamingListenerBus.doPostEventでonReceiverErrorが呼ばれる | E-05 | ○ |
| C-09 | StreamingJobProgressListenerがreceiverInfosを更新する | E-06 | ○ |
| C-10 | 送信抑止条件はなく常に発火される | E-03, E-04 | ○ |
| C-11 | ReceiverInfoのデフォルト値（lastErrorMessage=""等） | E-02 | ○ |
| C-12 | 配信はLiveListenerBus経由で非同期 | E-05 | ○ |
| C-13 | logWarningが未知streamId時に出力される | E-03 (行361) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり
- 0: 低リスク - エラー処理フローが明確

## 6) レビュアーチェックリスト（最小）
- [ ] reportErrorメソッドのerrorInfo更新ロジックが正しく記述されているか確認
- [ ] lastErrorTimeの引き継ぎロジックが正確か確認
- [ ] ReportErrorメッセージの処理がreceive（非同期）であることの記述が正しいか確認
