---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：84-StreamingListenerReceiverStopped

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` 行60-62
- E-02: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverInfo.scala` 行27-37
- E-03: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverTracker.scala` 行317-339
- E-04: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverTracker.scala` 行534-536
- E-05: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` 行56-57
- E-06: `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` 行87-90
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行85

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StreamingListenerReceiverStoppedはReceiverInfoを保持するケースクラス | E-01 | ○ |
| C-02 | ReceiverTracker.deregisterReceiverメソッドで発火される | E-03 | ○ |
| C-03 | DeregisterReceiverはreceiveAndReplyメソッドで処理される | E-04 | ○ |
| C-04 | ReceiverTrackingInfoをINACTIVE状態に更新する | E-03 (行324, 328) | ○ |
| C-05 | lastErrorTimeはerrorが空でなければclock.getTimeMillis()が設定される | E-03 (行318-319) | ○ |
| C-06 | 既存情報がない場合はlogWarningが出力され新規作成される | E-03 (行326-328) | ○ |
| C-07 | イベント発火後にlogErrorでメッセージが出力される | E-03 (行337-338) | ○ |
| C-08 | StreamingListenerBus.doPostEventでonReceiverStoppedが呼ばれる | E-05 | ○ |
| C-09 | StreamingJobProgressListenerがreceiverInfosを更新する | E-06 | ○ |
| C-10 | 応答としてtrue(Boolean)が返却される | E-04 | ○ |
| C-11 | ReceiverInfoのactive=falseとなる（INACTIVE判定） | E-02, E-03 | ○ |
| C-12 | 配信はLiveListenerBus経由で非同期 | E-05 | ○ |
| C-13 | レシーバー再起動はRestartReceiverメカニズムで別途管理 | E-03 (行483, 503) | ○ |
| C-14 | messageWithErrorはerrorの有無で形式が変わる | E-03 (行332-336) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり
- 0: 低リスク - 停止処理フローが明確

## 6) レビュアーチェックリスト（最小）
- [ ] deregisterReceiverメソッドの処理フローが正しく記述されているか確認
- [ ] lastErrorTimeの算出ロジックが正確か確認
- [ ] ReceiverInfoのactive判定ロジックが正しいか確認
