---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：85-SparkListenerConnectServiceStarted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` 行548-552
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` 行435-449
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` 行484-487
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` 行501-521
- E-05: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` 行319-321
- E-06: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` 行380-431
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行86

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerConnectServiceStartedはhostAddress, bindingPort, eventTimeを含むケースクラス | E-01 | ○ |
| C-02 | SparkListenerEventを直接継承している | E-01 | ○ |
| C-03 | startメソッドの最後でpostSparkConnectServiceStartedが呼ばれる | E-02 (行448) | ○ |
| C-04 | startメソッドはsynchronizedで保護されている | E-02 (行435) | ○ |
| C-05 | hostAddressはUtils.localCanonicalHostName()で取得される | E-05 | ○ |
| C-06 | bindingPortはbindingAddress.getPortで取得される | E-03 | ○ |
| C-07 | eventTimeはSystem.currentTimeMillis()で取得される | E-03 | ○ |
| C-08 | postServiceEventでserver/bindingAddress/listenerBusのnullチェックが行われる | E-04 | ○ |
| C-09 | nullの場合logWarningが出力されイベントがドロップされる | E-04 (行504-518) | ○ |
| C-10 | 二重起動時はlogWarningのみで早期リターンする | E-02 (行437-439) | ○ |
| C-11 | gRPCサーバー起動にNettyServerBuilderが使用される | E-06 | ○ |
| C-12 | ポートリトライはCONNECT_GRPC_PORT_MAX_RETRIESで制御 | E-06 (行426) | ○ |
| C-13 | createListenerAndUIでSparkConnectServerListenerが作成されStatusQueueに登録される | E-02, E-04 (行359-374) | ○ |
| C-14 | 起動後にstarted=true, stopped=falseが設定される | E-02 (行446-447) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり
- 0: 低リスク - サービス起動フローが明確

## 6) レビュアーチェックリスト（最小）
- [ ] startメソッドの処理順序が正しく記述されているか確認
- [ ] postServiceEventのnullチェック条件が網羅的か確認
- [ ] イベントフィールドの取得元が正しいか確認
