---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：86-SparkListenerConnectServiceEnd

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` 行566-567
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` 行451-478
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` 行492-495
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` 行501-521
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行87

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerConnectServiceEndはhostAddress, bindingPort, eventTimeを含む | E-01 | ○ |
| C-02 | stopメソッドの最後でpostSparkConnectServiceEndが呼ばれる | E-02 (行477) | ○ |
| C-03 | stopメソッドはsynchronizedで保護されている | E-02 (行451) | ○ |
| C-04 | 二重停止時はlogWarningで早期リターン | E-02 (行452-455) | ○ |
| C-05 | 未起動状態ではIllegalStateExceptionがスローされる | E-02 (行457-459) | ○ |
| C-06 | timeout指定時はgracefulシャットダウン | E-02 (行463-465) | ○ |
| C-07 | 未指定時はshutdownNow()が呼ばれる | E-02 (行467) | ○ |
| C-08 | 停止後にstarted=false, stopped=trueが設定される | E-02 (行475-476) | ○ |
| C-09 | postSparkConnectServiceEndはprivate[connect]スコープ | E-03 | ○ |
| C-10 | postServiceEventでnullチェックが行われる | E-04 | ○ |
| C-11 | 各マネージャーのシャットダウンが行われる | E-02 (行470-473) | ○ |
| C-12 | hostAddressはUtils.localCanonicalHostName()で取得 | E-03, E-04 | ○ |
| C-13 | eventTimeはSystem.currentTimeMillis()で取得 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] stopメソッドの処理順序が正しく記述されているか確認
- [ ] シャットダウンの種類（graceful/immediate）の説明が正確か確認
- [ ] postServiceEventのnullチェック条件が正確か確認
