---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：87-SparkListenerConnectSessionStarted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SessionEventsManager.scala` 行104-109
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SessionEventsManager.scala` 行58-66
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SessionEventsManager.scala` 行23-29
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SessionEventsManager.scala` 行81-91
- E-05: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` 行128, 280-283
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行88

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerConnectSessionStartedはsessionId, userId, eventTime, extraTagsを含む | E-01 | ○ |
| C-02 | SessionStatusはPending, Started, Closedの3状態を持つ | E-03 | ○ |
| C-03 | postStartedはPending状態からのみ呼び出し可能 | E-02 (行59) | ○ |
| C-04 | assertStatusで状態遷移の妥当性が検証される | E-04 | ○ |
| C-05 | sessionIdはsessionHolder.sessionIdから取得 | E-02 (行63) | ○ |
| C-06 | userIdはsessionHolder.userIdから取得 | E-02 (行64) | ○ |
| C-07 | eventTimeはclock.getTimeMillis()から取得 | E-02 (行65) | ○ |
| C-08 | extraTagsのデフォルトは空Map | E-01 | ○ |
| C-09 | SparkConnectServerListenerのonSessionStartedが呼ばれる | E-05 | ○ |
| C-10 | LiveSessionDataが作成される | E-05 (行280-283) | ○ |
| C-11 | 不正状態遷移時はIllegalStateExceptionがスローされる | E-04 (行85-88) | ○ |
| C-12 | SessionEventsManagerはケースクラスで、Clockを受け取る | E-02 (行39) | ○ |
| C-13 | sparkContext.listenerBus.postで配信される | E-02 (行60-61) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] SessionStatusの状態遷移ルールが正しく記述されているか確認
- [ ] postStartedメソッドの処理フローが正しいか確認
- [ ] SparkConnectServerListenerのセッション管理が正確に記述されているか確認
