---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：89-SparkListenerConnectOperationStarted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 行317-333
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 行111-141
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 行36-47
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 行274-290
- E-05: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 行31-33
- E-06: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` 行121, 173-193
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行90

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerConnectOperationStartedはjobTag, operationId, eventTime等を含む | E-01 | ○ |
| C-02 | planRequestは@JsonIgnoreアノテーション付きvar | E-01 (行332) | ○ |
| C-03 | postStartedはPending状態からのみ呼び出し可能 | E-02 (行112) | ○ |
| C-04 | セッションがStartedでないとIllegalStateException | E-04 (行283-288) | ○ |
| C-05 | OpTypeCaseでCommandまたはRootを判定 | E-02 (行115-121) | ○ |
| C-06 | statementTextはUtils.redactでリダクションされる | E-02 (行130) | ○ |
| C-07 | ProtoUtils.abbreviateで最大65535文字に制限 | E-02 (行134), E-05 (行32) | ○ |
| C-08 | MAX_STATEMENT_NESTING_LEVELは8 | E-05 (行33) | ○ |
| C-09 | event.planRequest = Some(request)で設定される | E-02 (行139) | ○ |
| C-10 | listenerBus.postでイベント配信 | E-02 (行140) | ○ |
| C-11 | SparkConnectServerListenerのonOperationStartedが呼ばれる | E-06 | ○ |
| C-12 | LiveExecutionDataが作成される | E-06 (行174-181) | ○ |
| C-13 | sessionData.totalExecution += 1が実行される | E-06 (行187) | ○ |
| C-14 | 未知のセッションIDの場合logWarningが出力される | E-06 (行189-191) | ○ |
| C-15 | ExecuteStatusはPending, Started, Analyzed等8状態を持つ | E-03 | ○ |
| C-16 | extraTagsのデフォルトは空Map | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり
- 1: 中リスク - statementTextのリダクションパターンはセッション設定に依存するため、設定不備によるデータ漏洩に注意

## 6) レビュアーチェックリスト（最小）
- [ ] postStartedメソッドのプラン解析ロジックが正しく記述されているか確認
- [ ] statementTextのリダクション処理が正確に記述されているか確認
- [ ] SparkConnectServerListenerのオペレーション管理が正しいか確認
- [ ] planRequestの@JsonIgnoreについて正確に記述されているか確認
