---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-SparkListenerConnectOperationAnalyzed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 行349-367
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 行153-162
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 行254-268
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 行274-290
- E-05: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` 行122, 195-206
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行91

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerConnectOperationAnalyzedはjobTag, operationId, eventTime, extraTagsを含む | E-01 | ○ |
| C-02 | parsedPlanとanalyzedPlanは@JsonIgnore付きvarフィールド | E-01 (行360-366) | ○ |
| C-03 | postAnalyzedはStartedまたはAnalyzed状態から呼び出し可能 | E-02 (行156) | ○ |
| C-04 | event.analyzedPlanとevent.parsedPlanが設定される | E-02 (行159-160) | ○ |
| C-05 | QueryPlanningTrackerCallbackのanalyzedコールバックからpostAnalyzedが呼ばれる | E-03 (行256-258) | ○ |
| C-06 | analysisFailedコールバックからpostAnalyzed(parsedPlan=Some)が呼ばれる | E-03 (行260-264) | ○ |
| C-07 | assertStatusで状態遷移とセッション状態が検証される | E-04 | ○ |
| C-08 | セッションがStartedでないとIllegalStateException | E-04 (行283-288) | ○ |
| C-09 | SparkConnectServerListenerのonOperationAnalyzedが呼ばれる | E-05 | ○ |
| C-10 | LiveExecutionDataのstateがCOMPILEDに更新される | E-05 (行199) | ○ |
| C-11 | 未知のオペレーションの場合logWarningが出力される | E-05 (行202-205) | ○ |
| C-12 | eventTimeはclock.getTimeMillis()から取得 | E-02 (行158) | ○ |
| C-13 | createQueryPlanningTrackerでコールバックが設定される | E-03 | ○ |
| C-14 | 解析成功時はanalyzedPlanが設定され、失敗時はparsedPlanが設定される | E-03 (行257, 263) | ○ |
| C-15 | extraTagsのデフォルトは空Map | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり
- 1: 中リスク - AnalyzedとCOMPILEDの名称の違いについて、UIレイヤーとの対応関係を確認する必要がある

## 6) レビュアーチェックリスト（最小）
- [ ] postAnalyzedメソッドの状態遷移ルール（Started/Analyzed -> Analyzed）が正しいか確認
- [ ] QueryPlanningTrackerCallbackの2つのコールバックの使い分けが正確に記述されているか確認
- [ ] analyzedPlan/parsedPlanの@JsonIgnoreについて正確に記述されているか確認
- [ ] AnalyzedとCOMPILEDの名称の対応関係が正しいか確認
