---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：91-SparkListenerConnectOperationReadyForExecution

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 384-389行目 - case class定義
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 168-172行目 - postReadyForExecution()
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 36-47行目 - ExecuteStatus定義
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 254-268行目 - createQueryPlanningTracker()
- E-05: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` 118-132行目 - onOtherEvent
- E-06: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` 208-219行目 - onOperationReadyForExecution
- E-07: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 274-290行目 - assertStatus
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 91行目 - 通知一覧エントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベントクラスはjobTag, operationId, eventTime, extraTagsフィールドを持つ | E-01 | ○ |
| C-02 | postReadyForExecution()はassertStatusでAnalyzedからの遷移を検証する | E-02, E-07 | ○ |
| C-03 | ExecuteStatusはPending→Started→Analyzed→ReadyForExecution→...の順で遷移する | E-03 | ○ |
| C-04 | QueryPlanningTrackerCallbackのreadyForExecutionコールバックが呼び出す | E-04 | ○ |
| C-05 | SparkConnectServerListenerのonOtherEventでパターンマッチされる | E-05 | ○ |
| C-06 | リスナー側でstateをExecutionState.READYに更新する | E-06 | ○ |
| C-07 | LiveListenerBus経由で非同期配信される | E-02 | ○ |
| C-08 | SparkListenerEventを継承する | E-01 | ○ |
| C-09 | セッションステータスがStartedでない場合はIllegalStateExceptionがスローされる | E-07 | ○ |
| C-10 | eagerコマンドはAnalysis完了後、その他はPlanning完了後に発火 | E-04 (Scaladoc 370-372行目) | ○ |
| C-11 | extraTagsのデフォルト値はMap.empty | E-01 | ○ |
| C-12 | 通知一覧で「Connectリクエストが実行準備完了した際に発火」と記載 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ExecuteEventsManager.scala 384-389行目のcase class定義がドキュメントと一致するか
- [ ] postReadyForExecution()のassertStatusの引数が正確か
- [ ] QueryPlanningTrackerCallbackのコールバック登録が正しく記載されているか
