---
generated_at: 2026-02-04 10:01:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：92-SparkListenerConnectOperationCanceled

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **C-13**：ErrorUtils以外の呼び出しパスの網羅性が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 404-409行目 - case class定義
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 177-189行目 - postCanceled()
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/utils/ErrorUtils.scala` 338-344行目 - isInterrupted判定
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` 222-234行目 - onOperationCanceled
- E-05: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 274-290行目 - assertStatus
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 92行目 - 通知一覧エントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベントクラスはjobTag, operationId, eventTime, extraTagsフィールドを持つ | E-01 | ○ |
| C-02 | postCanceled()はStarted, Analyzed, ReadyForExecution, Finished, Failedからの遷移を許可 | E-02 | ○ |
| C-03 | canceledフラグがSome(true)に設定される | E-02 (186行目) | ○ |
| C-04 | ErrorUtils内でisInterrupted判定によりpostCanceledが呼び分けられる | E-03 | ○ |
| C-05 | リスナー側でfinishTimestampとstateをCANCELEDに更新する | E-04 | ○ |
| C-06 | LiveListenerBus経由で非同期配信される | E-02 | ○ |
| C-07 | SparkListenerEventを継承する | E-01 | ○ |
| C-08 | セッションステータスがStartedでない場合はIllegalStateExceptionがスローされる | E-05 | ○ |
| C-09 | hasCanceledメソッドで参照可能 | E-02 (92行目) | ○ |
| C-10 | 通知一覧で「Connectリクエストがキャンセルされた際に発火」と記載 | E-06 | ○ |
| C-11 | executionListにjobTagが存在しない場合はログ警告を出力 | E-04 | ○ |
| C-12 | extraTagsのデフォルト値はMap.empty | E-01 | ○ |
| C-13 | ErrorUtils以外にpostCanceledを呼び出す箇所が存在しない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: ErrorUtils以外のpostCanceled呼び出し箇所の網羅的調査が未完了。プロジェクト全体のgrep結果は確認したが、全コードパスの完全な網羅性は保証できない
  - 候補：SparkConnectPlanner / SparkConnectStreamingQueryListenerHandler / その他

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な呼び出しパスはErrorUtilsから確認済み。他の呼び出し箇所があっても設計書の正確性には影響しない

## 6) レビュアーチェックリスト（最小）
- [ ] ExecuteEventsManager.scala 404-409行目のcase class定義がドキュメントと一致するか
- [ ] postCanceled()のassertStatusの引数リストが正確か
- [ ] ErrorUtils.scala 338-344行目のisInterrupted判定ロジックが正しく記載されているか
- [ ] postCanceledの呼び出し箇所がErrorUtils以外にもないか確認
