---
generated_at: 2026-02-04 10:02:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：93-SparkListenerConnectOperationFailed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **C-13**：errorMessageの内容にスタックトレースが含まれるかの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 426-432行目 - case class定義
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 197-212行目 - postFailed()
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/utils/ErrorUtils.scala` 338-344行目 - isInterrupted判定
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` 235-248行目 - onOperationFailed
- E-05: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 274-290行目 - assertStatus
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 93行目 - 通知一覧エントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベントクラスはjobTag, operationId, eventTime, errorMessage, extraTagsフィールドを持つ | E-01 | ○ |
| C-02 | postFailed()はStarted, Analyzed, ReadyForExecution, Finishedからの遷移を許可 | E-02 | ○ |
| C-03 | errorフラグがSome(true)に設定される | E-02 (205行目) | ○ |
| C-04 | ErrorUtils内でisInterrupted==falseの場合にpostFailedが呼ばれる | E-03 | ○ |
| C-05 | リスナー側でfinishTimestamp, detail, stateをFAILEDに更新する | E-04 | ○ |
| C-06 | errorMessageにはException.getMessageが渡される | E-03 (343行目) | ○ |
| C-07 | Canceledステータスからは遷移不可 | E-02 (199-203行目) | ○ |
| C-08 | SparkListenerEventを継承する | E-01 | ○ |
| C-09 | セッションステータスがStartedでない場合はIllegalStateExceptionがスローされる | E-05 | ○ |
| C-10 | 通知一覧で「Connectリクエストが失敗した際に発火」と記載 | E-06 | ○ |
| C-11 | hasErrorメソッドで参照可能 | E-02 (99行目) | ○ |
| C-12 | errorMessageフィールドが他のOperationイベントにはない唯一のフィールド | E-01 (比較) | ○ |
| C-13 | errorMessageにスタックトレースやクエリ情報が含まれる可能性がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: errorMessageの実際の内容はException.getMessage()の返却値に依存する。wrapped.getMessage()がどのレベルの情報を含むかは例外の種類に依存し、ソースコードからは完全に特定できない
  - 候補：ErrorUtils内のwrap処理の詳細確認 / 各種例外クラスのgetMessage実装

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - errorMessageの内容がセキュリティ考慮事項に影響するため、実際の内容の確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] ExecuteEventsManager.scala 426-432行目のcase class定義がドキュメントと一致するか
- [ ] postFailed()のassertStatusの引数リストにCanceledが含まれていないことを確認
- [ ] ErrorUtils.scala 343行目のwrapped.getMessage()が正しいか
- [ ] errorMessageに機密情報が含まれないことを確認
