---
generated_at: 2026-02-04 10:03:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：94-SparkListenerConnectOperationFinished

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 451-457行目 - case class定義
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 220-236行目 - postFinished()
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/execution/SparkConnectPlanExecution.scala` 100行目 - コマンド完了後
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/execution/SparkConnectPlanExecution.scala` 210行目 - LocalTableScanExec
- E-05: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/execution/SparkConnectPlanExecution.scala` 242行目 - 全パーティション完了
- E-06: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/execution/SparkConnectPlanExecution.scala` 298行目 - 空結果
- E-07: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` 249-261行目 - onOperationFinished
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 94行目 - 通知一覧エントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベントクラスはjobTag, operationId, eventTime, producedRowCount, extraTagsフィールドを持つ | E-01 | ○ |
| C-02 | postFinished()はStartedまたはReadyForExecutionからの遷移を許可 | E-02 | ○ |
| C-03 | producedRowCountはOption[Long]型 | E-01 | ○ |
| C-04 | コマンド実行完了後にpostFinished()（行数なし）が呼ばれる | E-03 | ○ |
| C-05 | LocalTableScanExec完了後にSome(rows.length)が渡される | E-04 | ○ |
| C-06 | 全パーティション完了後にSome(totalNumRows)が渡される | E-05 | ○ |
| C-07 | 空結果時にSome(0)が渡される | E-06 | ○ |
| C-08 | リスナー側でfinishTimestampとstateをFINISHEDに更新する | E-07 | ○ |
| C-09 | LiveListenerBus経由で非同期配信される | E-02 | ○ |
| C-10 | 内部のproducedRowCountフィールドも更新される | E-02 (226行目) | ○ |
| C-11 | postFinishedはproducedRowsCountOptとextraTagsの2引数を受け取る | E-02 | ○ |
| C-12 | SparkListenerEventを継承する | E-01 | ○ |
| C-13 | 通知一覧で「実行完了後（結果送信前）に発火」と記載 | E-08 | ○ |
| C-14 | Finished -> Closedが通常フロー | E-02, E-01 (Scaladoc) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能。4つの呼び出し箇所も全て特定済み

## 6) レビュアーチェックリスト（最小）
- [ ] ExecuteEventsManager.scala 451-457行目のcase class定義がドキュメントと一致するか
- [ ] SparkConnectPlanExecution.scalaの4つの呼び出し箇所が正確か
- [ ] producedRowCountの各呼び出し箇所での値が正しいか
