---
generated_at: 2026-02-04 10:04:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：95-SparkListenerConnectOperationClosed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 472-477行目 - case class定義
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 241-247行目 - postClosed()
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteHolder.scala` 308-311行目 - close()
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` 262-278行目 - onOperationClosed
- E-05: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` 274-290行目 - assertStatus
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 95行目 - 通知一覧エントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベントクラスはjobTag, operationId, eventTime, extraTagsフィールドを持つ | E-01 | ○ |
| C-02 | postClosed()はFinished, Failed, Canceledからの遷移を許可 | E-02 | ○ |
| C-03 | ExecuteHolder.close()内でpostClosed()が呼ばれる | E-03 | ○ |
| C-04 | responseObserver.removeAll()の後にpostClosed()が呼ばれる | E-03 | ○ |
| C-05 | リスナー側でcloseTimestampとstateをCLOSEDに更新する | E-04 | ○ |
| C-06 | executionList.computeでatomicに更新と削除を実行する | E-04 | ○ |
| C-07 | nullを返すことでConcurrentHashMapからエントリを削除する | E-04 (276行目) | ○ |
| C-08 | updateStoreWithTriggerEnabledが使用される | E-04 (267行目) | ○ |
| C-09 | SparkListenerEventを継承する | E-01 | ○ |
| C-10 | オペレーションのライフサイクル最終イベントである | E-02 (Scaladoc 459-461行目) | ○ |
| C-11 | 通知一覧で「実行完了・結果送信後に発火」と記載 | E-06 | ○ |
| C-12 | セッションステータスがStartedでない場合はIllegalStateException | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ExecuteEventsManager.scala 472-477行目のcase class定義がドキュメントと一致するか
- [ ] ExecuteHolder.scala 308-311行目のclose()処理順序が正確か
- [ ] SparkConnectServerListener.scalaの262-278行目のcompute処理がnull返却でエントリ削除されることの確認
