---
generated_at: 2026-02-04 10:07:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：98-SparkListenerThriftServerOperationStart

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **C-12**：onStatementStartの全呼び出し元の網羅性

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` 88-94行目 - case class定義
- E-02: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` 42-49行目 - onStatementStart()
- E-03: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` 149-170行目 - onOperationStart
- E-04: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` 83-91行目 - onJobStart
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 98行目 - 通知一覧エントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベントクラスはid, sessionId, statement, groupId, startTime, userNameフィールドを持つ | E-01 | ○ |
| C-02 | private[thriftserver]スコープで定義されている | E-01 | ○ |
| C-03 | onStatementStart()でSystem.currentTimeMillis()がstartTimeとして使用される | E-02 | ○ |
| C-04 | リスナー側でgetOrCreateExecution、state=STARTED、executionList.put、groupId設定が行われる | E-03 | ○ |
| C-05 | 関連セッションのtotalExecutionが増加される | E-03 (164行目) | ○ |
| C-06 | sessionListにsessionIdが存在しない場合でもオペレーション自体は登録される | E-03 (166-168行目) | ○ |
| C-07 | groupIdはSparkContext.SPARK_JOB_GROUP_IDに対応する | E-04 (86行目) | ○ |
| C-08 | userName引数のデフォルト値は"UNKNOWN" | E-02 | ○ |
| C-09 | SparkListenerEventを継承する | E-01 | ○ |
| C-10 | 通知一覧で「ThriftServerオペレーションが開始された際に発火」と記載 | E-05 | ○ |
| C-11 | オペレーション数の上限はSQLConf.THRIFTSERVER_UI_STATEMENT_LIMITで設定される | E-03 (48-51行目) | ○ |
| C-12 | SparkExecuteStatementOperation等の複数のオペレーションクラスから呼び出される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12: onStatementStartの全呼び出し元の網羅的な確認が未完了。grep結果で11ファイルが検出されたが、SparkExecuteStatementOperation以外の具体的な呼び出し箇所は個別確認していない
  - 候補：SparkGetCatalogsOperation / SparkGetColumnsOperation / SparkGetFunctionsOperation / SparkGetSchemasOperation / SparkGetTablesOperation / SparkGetTableTypesOperation / SparkGetTypeInfoOperation

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 呼び出し元の網羅性が不完全だが、イベントクラスとリスナー処理の記述は正確

## 6) レビュアーチェックリスト（最小）
- [ ] HiveThriftServer2EventManager.scala 88-94行目のcase class定義がドキュメントと一致するか
- [ ] HiveThriftServer2Listener.scala 149-170行目のリスナー処理が正しく記載されているか
- [ ] onStatementStartの主要な呼び出し元が網羅されているか確認
