---
generated_at: 2026-02-04 10:08:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：99-SparkListenerThriftServerOperationParsed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **C-10**：executionPlanの具体的な生成元（QueryExecution.toString等）の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` 96-98行目 - case class定義
- E-02: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` 52-53行目 - onStatementParsed()
- E-03: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` 172-181行目 - onOperationParsed
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 99行目 - 通知一覧エントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベントクラスはid, executionPlanフィールドのみを持つ | E-01 | ○ |
| C-02 | private[thriftserver]スコープで定義されている | E-01 | ○ |
| C-03 | onStatementParsed()はid, executionPlanの2引数のみ | E-02 | ○ |
| C-04 | リスナー側でexecutePlanとstateをCOMPILEDに更新する | E-03 | ○ |
| C-05 | executionListにidが存在しない場合はログ警告 | E-03 (178-180行目) | ○ |
| C-06 | finishTimeフィールドが含まれない（他のイベントとは異なる） | E-01 | ○ |
| C-07 | SparkListenerEventを継承する | E-01 | ○ |
| C-08 | 通知一覧で「ThriftServerオペレーションの解析完了後に発火」と記載 | E-04 | ○ |
| C-09 | 状態遷移としてSTARTED -> COMPILEDを表す | E-03 (176行目) | ○ |
| C-10 | executionPlanの具体的なデータ取得元はQueryExecution.toString等 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-10: executionPlanの具体的な生成方法はSparkExecuteStatementOperationの内部処理に依存する。onStatementParsedの引数として渡されるexecutionPlanの生成元の確認が未完了
  - 候補：SparkExecuteStatementOperation内のqueryExecution.toString / spark.sql.execution.QueryExecution

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - executionPlanの生成元が未特定だが、イベントクラスとリスナー処理の記述は正確

## 6) レビュアーチェックリスト（最小）
- [ ] HiveThriftServer2EventManager.scala 96-98行目のcase class定義がドキュメントと一致するか
- [ ] HiveThriftServer2Listener.scala 172-181行目のリスナー処理が正しく記載されているか
- [ ] executionPlanの具体的な生成元を確認
