---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 30
  claims_without_evidence: 5
confidence_derived: 0.86
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：30 / 35、根拠なし：5
- 優先レビュー（高）
  1. **ブラウザ対応情報**：Spark Web UIの公式ドキュメントからの明確な対応ブラウザ情報なし
  2. **History Serverのデフォルトポート**：18080はデフォルト値だが、設定により変更される場合のカバーが不足
  3. **ACL設定の詳細なプロパティ名**：一部プロパティ名の正確性について要確認
  4. **パスワードリセット手順**：Sparkは独自認証を持たないため、認証に関する記述の正確性を要確認
  5. **トラブルシューティングの具体的な閾値**：データスキュー判定のMax/Median比率など具体的な閾値は推定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv` - 全29画面の一覧定義
- E-02: `docs/code-to-docs/画面一覧/画面遷移図.md` - Mermaid形式の画面遷移定義
- E-03: `docs/code-to-docs/画面設計書/1-All Jobs（全ジョブ一覧）.md` - All Jobs画面の設計書
- E-04: `docs/code-to-docs/画面設計書/9-Environment（環境情報）.md` - Environment画面の設計書
- E-05: `docs/code-to-docs/画面設計書/10-Executors（エグゼキュータ一覧）.md` - Executors画面の設計書
- E-06: `docs/code-to-docs/画面設計書/14-SQL All Executions（SQL実行一覧）.md` - SQL実行一覧の設計書
- E-07: `docs/code-to-docs/画面設計書/24-Master Overview（マスター概要）.md` - Master Overview画面の設計書
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 全画面と機能の対応定義
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 全97機能の一覧定義
- E-10: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 全55業務要件の定義
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` - 全105通知イベントの定義
- E-12: `core/src/main/scala/org/apache/spark/ui/` - Spark Web UIのソースコードディレクトリ
- E-13: `core/src/main/scala/org/apache/spark/deploy/master/ui/` - Standalone Master UIのソースコード
- E-14: `core/src/main/scala/org/apache/spark/deploy/worker/ui/` - Standalone Worker UIのソースコード
- E-15: `core/src/main/scala/org/apache/spark/deploy/history/` - History Serverのソースコード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Web UIのデフォルトポートは4040である | E-03 | ○ |
| C-02 | ルート(/)から/jobs/にリダイレクトされる | E-01, E-03 | ○ |
| C-03 | All Jobs画面にActive/Completed/Failedの3分類でジョブを表示 | E-03 | ○ |
| C-04 | Event Timelineでジョブの時系列可視化が可能 | E-03 | ○ |
| C-05 | ジョブのKill操作が可能（killEnabled設定とACL権限が必要） | E-03, E-07 | ○ |
| C-06 | ナビゲーションバーにJobs/Stages/Storage/Environment/Executorsタブがある | E-01, E-02 | ○ |
| C-07 | SQLタブはSQLモジュール使用時のみ表示 | E-06 | ○ |
| C-08 | Streamingタブはストリーミング使用時のみ表示 | E-01, E-02 | ○ |
| C-09 | ConnectタブはSpark Connect Server使用時のみ表示 | E-01, E-02 | ○ |
| C-10 | Job Detail画面でDAG可視化が可能 | E-08 | ○ |
| C-11 | ステージがActive/Pending/Complete/Skipped/Failedに分類される | E-01 | ○ |
| C-12 | Stage DetailでSummary Metrics（Duration, GC Time, Shuffle Read/Write等）を表示 | E-08 | ○ |
| C-13 | FAIRスケジューラ使用時にPool情報が表示される | E-01, E-08 | ○ |
| C-14 | Executors画面でRDD Blocks/Storage Memory/Disk Used/Tasks統計等を表示 | E-05 | ○ |
| C-15 | Thread Dump機能はspark.ui.threadDumpsEnabledで制御 | E-05 | ○ |
| C-16 | Heap Histogram機能はspark.ui.heapHistogramEnabledで制御 | E-05 | ○ |
| C-17 | Storage画面でRDDのストレージレベル/キャッシュパーティション数/メモリ・ディスク使用量を表示 | E-08 | ○ |
| C-18 | Environment画面でJVM情報/Sparkプロパティ/Hadoopプロパティ等を表示 | E-04 | ○ |
| C-19 | 機密情報はUtils.redactでマスク処理される | E-04 | ○ |
| C-20 | SQL Execution Detail画面で物理実行計画とDAGグラフを表示 | E-06, E-08 | ○ |
| C-21 | ThriftServer Overview画面でセッション・SQL統計を表示 | E-08 | ○ |
| C-22 | Connect Server Overview画面でセッション・リクエスト統計を表示 | E-08 | ○ |
| C-23 | Streaming Query Statistics画面で入力レート/処理レート/バッチ期間等のグラフを表示 | E-08 | ○ |
| C-24 | Master UIのデフォルトポートは8080 | E-07 | ○ |
| C-25 | Master Overview画面でWorkers/Applications/Drivers一覧を表示 | E-07 | ○ |
| C-26 | Master UIでアプリケーション/ドライバーのKill操作が可能 | E-07 | ○ |
| C-27 | Worker UIでExecutor/ドライバーのログ確認が可能 | E-01, E-14 | ○ |
| C-28 | History Serverで完了済みアプリケーションの履歴を参照可能 | E-09, E-10, E-15 | ○ |
| C-29 | Driver Log画面はDRIVER_LOG_LOCAL_DIR設定時のみ有効 | E-01 | ○ |
| C-30 | DStreams Streaming画面でスケジューリング遅延/処理時間/総遅延のタイムライン・ヒストグラムを表示 | E-08 | ○ |
| C-31 | 推奨ブラウザとしてChrome/Edge/Safari/Firefoxを記載 | **根拠なし** | △ |
| C-32 | History Serverのデフォルトポートは18080 | **根拠なし** | △ |
| C-33 | Worker UIのデフォルトポートは8081 | **根拠なし** | △ |
| C-34 | spark.acls.enable/spark.ui.view.acls等のACL設定プロパティ名 | **根拠なし** | △ |
| C-35 | トラブルシューティングにおけるデータスキュー判定基準（Max/Medianの数倍以上） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-31（推奨ブラウザ）: Spark Web UIの公式ドキュメントに明確なブラウザ対応情報が見つからなかった。jQuery/DataTables/D3.jsを使用している点からモダンブラウザでの動作は推定可能だが、公式の対応ブラウザリストは未確認
  - 候補：Apache Spark公式ドキュメント / Web UIのJavaScript依存ライブラリのブラウザサポート情報
- C-32（History Serverポート）: History Serverの設定ファイル（spark-defaults.conf）やソースコードからデフォルトポートを確認する必要がある
  - 候補：`core/src/main/scala/org/apache/spark/deploy/history/HistoryServer.scala` / 公式ドキュメント
- C-33（Worker UIポート）: Worker UIのデフォルトポートはソースコードから確認する必要がある
  - 候補：`core/src/main/scala/org/apache/spark/deploy/worker/Worker.scala` / 公式ドキュメント
- C-34（ACL設定プロパティ名）: 正確なプロパティ名はSparkの設定ドキュメントまたはSecurityManager.scalaから確認が必要
  - 候補：`core/src/main/scala/org/apache/spark/SecurityManager.scala` / 公式ドキュメント
- C-35（データスキュー判定基準）: 具体的な閾値は公式なものではなく、一般的なベストプラクティスに基づく推定値
  - 候補：Apache Spark公式チューニングガイド / パフォーマンスチューニングの参考文献

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成・機能説明（C-01〜C-30）はすべて画面設計書・画面一覧・画面機能マッピングに根拠があり、信頼性が高い
- 1: 中リスク - ポート番号やACL設定プロパティ名（C-32〜C-34）はSparkの広く知られた設定値だが、本プロジェクト固有の設定があれば修正が必要
- 1: 中リスク - 推奨ブラウザ（C-31）は一般的なモダンブラウザを記載しているが、公式根拠がない
- 0: 低リスク - トラブルシューティング（C-35）は一般的なベストプラクティスに基づいており、実用上問題ない

## 6) レビュアーチェックリスト（最小）
- [ ] 画面名・URL・操作手順が実際のSpark Web UIと一致しているか確認
- [ ] ナビゲーションバーのタブ構成が実際の画面と一致しているか確認
- [ ] ACL関連の設定プロパティ名が正確か確認（SecurityManager.scalaを参照）
- [ ] History Server/Worker UIのデフォルトポート番号が正しいか確認
- [ ] Kill操作の権限チェック手順が正確か確認
- [ ] 業務フロー（STEP1〜5）がユーザーの実際の業務に適合しているか確認
- [ ] トラブルシューティングの対処法が実環境で有効か確認
