# Apache Spark Web UI 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・アクセス手順](#2-ログインアクセス手順)
3. [トップページ（TOP画面）](#3-トップページtop画面)

**【業務フローに沿った機能】**
4. [【STEP1】アプリケーション投入・実行開始（ジョブの投入）](#4-step1アプリケーション投入実行開始ジョブの投入)
5. [【STEP2-3】ジョブ・ステージの監視（実行状況の確認）](#5-step2-3ジョブステージの監視実行状況の確認)
6. [【STEP3-4】リソース・データの確認（実行環境の把握）](#6-step3-4リソースデータの確認実行環境の把握)
7. [【STEP4-5】問題対応・処理完了（障害対応と完了確認）](#7-step4-5問題対応処理完了障害対応と完了確認)

**【サポート機能】**
8. [SQL/DataFrameクエリ監視機能](#8-sqldataframeクエリ監視機能)
9. [ストリーミング処理監視機能](#9-ストリーミング処理監視機能)
10. [クラスタ管理機能（Standalone Mode）](#10-クラスタ管理機能standalone-mode)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 Apache Spark Web UIとは

Apache Spark Web UIは、Sparkアプリケーションの実行状況をリアルタイムで可視化するWebインターフェースです。データエンジニア、データサイエンティスト、クラスタ管理者が、ジョブの進捗確認、パフォーマンスチューニング、障害対応を行うために使用します。

Sparkアプリケーションを起動すると自動的にWeb UIが立ち上がり、ブラウザからアクセスすることで、ジョブ・ステージ・タスクの進捗状況、リソース使用状況、環境設定情報などを確認できます。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します:

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **ジョブ監視** | ジョブの進捗確認、実行時間の把握、失敗ジョブの検出 |
| **パフォーマンス分析** | ステージ・タスクレベルのメトリクス確認、シャッフルデータ量の把握、実行計画の確認 |
| **リソース管理** | Executorのリソース使用状況確認、メモリ使用量の把握、ストレージ状態の確認 |
| **環境確認** | Sparkプロパティの確認、JVM設定の確認、クラスパス情報の確認 |
| **SQL/ストリーミング監視** | SQLクエリの実行状況確認、ストリーミングクエリの処理レート監視 |
| **クラスタ管理** | ワーカーノードの状態確認、アプリケーション管理、ログ確認 |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します:

```
+-------------------------------------------------------------------+
|                        業務フロー                                  |
+-------------------------------------------------------------------+
|                                                                    |
|  【STEP 1】アプリケーションを投入し、Sparkジョブを開始する           |
|      |                                                             |
|  【STEP 2】Web UIでジョブ・ステージの実行状況をリアルタイム監視する   |
|      |                                                             |
|  【STEP 3】リソース使用状況・メトリクスを確認し問題を特定する        |
|      |                                                             |
|  【STEP 4】問題発生時はジョブのKillやパラメータ調整で対応する        |
|      |                                                             |
|  【STEP 5】処理完了を確認し、必要に応じてHistory Serverで履歴を参照  |
|                                                                    |
+-------------------------------------------------------------------+
```

**役割別の業務概要:**

| 役割 | 主な業務 |
|------|---------|
| **データエンジニア** | アプリケーション投入、ジョブ進捗確認、SQLクエリの最適化、障害対応 |
| **データサイエンティスト** | 機械学習ジョブの監視、実行時間の把握、リソース使用状況の確認 |
| **クラスタ管理者** | クラスタ全体のリソース管理、ワーカーノードの監視、アプリケーション管理 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| Jobs（ジョブ一覧） | 全ジョブの進捗をタイムライン・テーブル形式で表示 | STEP 1-2 |
| Stages（ステージ一覧） | 全ステージの進捗を分類表示 | STEP 2-3 |
| Storage（ストレージ一覧） | RDDのキャッシュ状況を表示 | STEP 3 |
| Environment（環境情報） | 実行環境のプロパティ一覧を表示 | STEP 3 |
| Executors（エグゼキュータ一覧） | Executorのリソース・タスク統計を表示 | STEP 3-4 |
| SQL / DataFrame | SQLクエリの実行状況を表示 | STEP 2-3 |
| Streaming | ストリーミングクエリの処理統計を表示 | STEP 2-3 |
| Master / Worker UI | Standaloneクラスタの管理画面 | STEP 1, 4-5 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります:

| ユーザー種別 | 説明 |
|-------------|------|
| 一般ユーザー（閲覧権限） | ジョブの進捗確認、メトリクスの閲覧が可能。ACL設定時はviewAclsに登録されたユーザー |
| 管理者（変更権限） | ジョブのKill操作、アプリケーションのKill操作が可能。ACL設定時はmodifyAclsに登録されたユーザー |
| クラスタ管理者 | Standalone Modeにおけるマスター/ワーカーUIへのアクセスとクラスタ全体の管理が可能 |

### 1.6 対応ブラウザ

推奨ブラウザ:
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

> **注意**: Web UIはJavaScript（jQuery、DataTables、D3.js等）を使用しています。JavaScriptが有効になっていることを確認してください。

---

## 2. ログイン・アクセス手順

### 2.1 Spark Application UIへのアクセス

Sparkアプリケーション実行中のWeb UIにアクセスする手順です。

1. Sparkアプリケーションが実行中であることを確認します
2. ブラウザで以下のURLにアクセスします

| 項目 | アクセス先 |
|------|-----------|
| デフォルトURL | `http://<ドライバホスト名>:4040` |
| ポート番号 | デフォルトは4040。使用中の場合は4041, 4042...と順番に試行されます |
| 設定変更 | `spark.ui.port` プロパティでカスタムポートを指定可能 |

3. アクセスするとルート（/）から「All Jobs」画面（/jobs/）にリダイレクトされます

### 2.2 ACLが有効な場合の認証

`spark.acls.enable` が `true` に設定されている場合、アクセス制御が有効になります。

| 設定項目 | 説明 |
|---------|------|
| `spark.ui.view.acls` | 閲覧を許可するユーザーのカンマ区切りリスト |
| `spark.ui.view.acls.groups` | 閲覧を許可するグループのカンマ区切りリスト |
| `spark.modify.acls` | 変更操作（Kill等）を許可するユーザーのカンマ区切りリスト |
| `spark.admin.acls` | 全操作を許可する管理者ユーザーのカンマ区切りリスト |

### 2.3 History Serverへのアクセス

完了済みアプリケーションの履歴を確認する場合、History Serverにアクセスします。

1. ブラウザで `http://<HistoryServerホスト名>:18080` にアクセスします
2. アプリケーション一覧から確認したいアプリケーションを選択します
3. 実行中のWeb UIと同じ画面構成で履歴を参照できます

### 2.4 Standaloneクラスタ管理UIへのアクセス

| UI | デフォルトURL | 説明 |
|-----|-------------|------|
| Master UI | `http://<マスターホスト名>:8080` | クラスタ全体の管理画面 |
| Worker UI | `http://<ワーカーホスト名>:8081` | 個別ワーカーの管理画面 |

---

## 3. トップページ（TOP画面）

### 3.1 All Jobs画面（デフォルト表示）

Spark Application UIにアクセスすると、デフォルトで「All Jobs（全ジョブ一覧）」画面が表示されます。この画面はアプリケーション全体のジョブ状況を把握するためのダッシュボードです。

**画面の構成:**

| セクション | 説明 |
|-----------|------|
| サマリーヘッダ | ユーザー名、開始日時、稼働時間、スケジューリングモード（FIFO/FAIR）を表示 |
| Event Timeline | ジョブとExecutorの時系列イベントを可視化（折りたたみ可能） |
| Active Jobs | 実行中のジョブ一覧テーブル |
| Completed Jobs | 完了したジョブ一覧テーブル |
| Failed Jobs | 失敗したジョブ一覧テーブル |

**ナビゲーションバー:**

画面上部のタブから各画面に遷移できます:

| タブ名 | 遷移先 | 表示条件 |
|--------|--------|---------|
| Jobs | All Jobs画面 | 常時表示 |
| Stages | All Stages画面 | 常時表示 |
| Storage | Storage一覧画面 | 常時表示 |
| Environment | Environment画面 | 常時表示 |
| Executors | Executors一覧画面 | 常時表示 |
| SQL / DataFrame | SQL実行一覧画面 | SQLモジュール使用時のみ |
| Streaming | ストリーミングクエリ一覧画面 | Structured Streaming使用時のみ |
| JDBC/ODBC Server | ThriftServer概要画面 | ThriftServer使用時のみ |
| Connect | Spark Connect Server概要画面 | Spark Connect Server使用時のみ |

### 3.2 画面共通の操作

**テーブルの操作:**
- カラムヘッダをクリックするとソート順を切り替えられます
- ページング機能により大量データを分割表示できます
- ページサイズの変更が可能です

---

## 4. 【STEP1】アプリケーション投入・実行開始（ジョブの投入）

> **業務フローでの位置**: ユーザーがSparkアプリケーションを投入し、ジョブの実行を開始するステップです。Web UIはアプリケーション起動と同時に自動的に利用可能になります。

### 4.1 アプリケーションの投入

Sparkアプリケーションは `spark-submit` コマンドを使用して投入します。投入後、自動的にWeb UIが起動します。

**基本的な投入手順:**

1. ターミナルで `spark-submit` コマンドを実行します
2. アプリケーションが起動すると、コンソールにWeb UIのURLが表示されます
3. 表示されたURL（通常 `http://<ホスト名>:4040`）をブラウザで開きます
4. 「All Jobs」画面で投入したジョブの状況が表示されていることを確認します

### 4.2 ジョブの開始を確認する

1. 「All Jobs」画面にアクセスします
2. 「Active Jobs」セクションに新しいジョブが表示されることを確認します
3. 各ジョブの以下の情報を確認します:

| 確認項目 | 説明 |
|---------|------|
| Job Id | ジョブの一意識別子 |
| Description | ジョブの説明（最後のステージの説明が表示されます） |
| Submitted | ジョブの投入日時 |
| Duration | 実行中の経過時間 |
| Stages: Succeeded/Total | 完了ステージ数 / 総ステージ数 |
| Tasks | タスクの進捗バー（色分け表示） |

### 4.3 Event Timelineの活用

Event Timelineでは、ジョブとExecutorの時系列イベントを視覚的に確認できます。

1. 「Event Timeline」セクションの展開ボタンをクリックします
2. タイムライン上でジョブの開始・終了を確認します
   - 緑色のバー: 成功したジョブ
   - 赤色のバー: 失敗したジョブ
   - 青色のバー: 実行中のジョブ
3. Executorの追加・削除イベントもポイントで表示されます
4. マウスホイールでタイムラインのズーム操作が可能です

---

## 5. 【STEP2-3】ジョブ・ステージの監視（実行状況の確認）

> **業務フローでの位置**: アプリケーション投入後、ジョブとステージの実行状況をリアルタイムで監視し、進捗を確認するステップです。

### 5.1 ジョブ詳細の確認

1. 「All Jobs」画面で確認したいジョブの「Job Id」リンクをクリックします
2. 「Job Detail」画面が表示されます

**Job Detail画面の確認項目:**

| セクション | 確認内容 |
|-----------|---------|
| Status | ジョブの現在の状態（RUNNING / SUCCEEDED / FAILED） |
| DAG Visualization | ステージ間の依存関係をグラフで表示（展開ボタンで表示） |
| Active Stages | 実行中のステージ一覧 |
| Completed Stages | 完了したステージ一覧 |
| Skipped Stages | スキップされたステージ一覧 |
| Failed Stages | 失敗したステージ一覧 |

### 5.2 ステージ一覧の確認

1. ナビゲーションバーの「Stages」タブをクリックします
2. 「All Stages」画面で全ステージの状態を確認します

**ステージの分類:**

| 分類 | 説明 |
|------|------|
| Active Stages | 現在実行中のステージ |
| Pending Stages | 実行待ちのステージ |
| Completed Stages | 正常に完了したステージ |
| Skipped Stages | キャッシュヒット等でスキップされたステージ |
| Failed Stages | 失敗したステージ |

### 5.3 ステージ詳細の確認

1. ステージ一覧から確認したいステージの「Stage Id」リンクをクリックします
2. 「Stage Detail」画面で詳細を確認します

**Stage Detail画面の確認項目:**

| セクション | 確認内容 |
|-----------|---------|
| Summary Metrics | タスクメトリクスの分布（Duration、GC Time、Input/Output、Shuffle Read/Write等） |
| DAG Visualization | ステージ内の物理実行計画グラフ |
| Tasks テーブル | 各タスクの詳細情報（Status、Locality Level、Duration、GC Time等） |

**Summary Metricsで確認すべきポイント:**

| メトリクス | 注目する値 |
|-----------|-----------|
| Duration | Min/Median/Maxの差が大きい場合、データスキューの可能性 |
| GC Time | 全体に占める割合が大きい場合、メモリ不足の可能性 |
| Shuffle Read Size | データ量が想定より大きい場合、パーティション設計の見直しが必要 |
| Shuffle Write Size | シャッフルデータ量の確認 |
| Spill (Memory/Disk) | メモリスピルが発生している場合、メモリ設定の見直しが必要 |

### 5.4 FAIRスケジューラ使用時のプール確認

スケジューリングモードがFAIRの場合、「All Stages」画面にプール情報が表示されます。

1. 「All Stages」画面でFAIRスケジューラのプール一覧を確認します
2. プール名リンクをクリックすると「Pool Detail」画面に遷移します
3. プールの設定（minShare、weight）とプール内のアクティブステージを確認できます

---

## 6. 【STEP3-4】リソース・データの確認（実行環境の把握）

> **業務フローでの位置**: ジョブ実行中のリソース使用状況やストレージ状態、環境設定を確認し、必要に応じてパフォーマンスの問題を特定するステップです。

### 6.1 Executor情報の確認

1. ナビゲーションバーの「Executors」タブをクリックします
2. 全Executorのリソース使用状況が一覧表示されます

**Executor一覧テーブルの主要カラム:**

| カラム名 | 説明 | 注目ポイント |
|---------|------|------------|
| Executor ID | ExecutorのID | ドライバは「driver」と表示 |
| Address | Executorのホスト:ポート | - |
| Status | Active / Dead | Dead状態のExecutorに注意 |
| RDD Blocks | キャッシュしているRDDブロック数 | - |
| Storage Memory | ストレージメモリの使用量/上限 | 上限に近い場合は注意 |
| Disk Used | ディスク使用量 | スピルが発生している可能性 |
| Active Tasks | 実行中のタスク数 | - |
| Failed Tasks | 失敗したタスク数 | 数値が大きい場合は調査が必要 |
| Total Tasks | 処理済みの総タスク数 | - |
| Task Time | 累計のタスク実行時間 | - |
| Shuffle Read / Write | シャッフルデータの読み書き量 | - |

**詳細診断機能:**

| 機能 | アクセス方法 | 用途 |
|------|------------|------|
| Thread Dump | Executorの「Thread Dump」リンクをクリック | スレッドの状態確認、デッドロック検出 |
| Heap Histogram | Executorの「Heap Histogram」リンクをクリック | メモリ上のオブジェクト分布確認 |

> **注意**: Thread Dump機能は `spark.ui.threadDumpsEnabled` が `true`（デフォルト）の場合に利用可能です。Heap Histogram機能は `spark.ui.heapHistogramEnabled` が `true` の場合に利用可能です。

### 6.2 ストレージ情報の確認

1. ナビゲーションバーの「Storage」タブをクリックします
2. キャッシュされた全RDDの一覧が表示されます

**Storage一覧テーブルの確認項目:**

| カラム名 | 説明 |
|---------|------|
| RDD Name | RDD名 |
| Storage Level | ストレージレベル（MEMORY_ONLY、MEMORY_AND_DISK等） |
| Cached Partitions | キャッシュ済みパーティション数 |
| Fraction Cached | キャッシュ率 |
| Size in Memory | メモリ上のサイズ |
| Size on Disk | ディスク上のサイズ |

**RDD詳細の確認:**

1. RDD名のリンクをクリックします
2. 「RDD Detail」画面でExecutor別のデータ分布を確認できます
3. パーティションごとのストレージ情報も確認可能です

### 6.3 環境情報の確認

1. ナビゲーションバーの「Environment」タブをクリックします
2. 以下のセクションが表示されます:

| セクション | 説明 | デフォルト表示 |
|-----------|------|--------------|
| Runtime Information | Java Version、Java Home、Scala Version | 展開状態 |
| Spark Properties | Sparkの設定プロパティ一覧 | 展開状態 |
| Resource Profiles | Executor/Taskのリソース要求 | 展開状態 |
| Hadoop Properties | Hadoopの設定プロパティ一覧 | 折りたたみ状態 |
| System Properties | JVMシステムプロパティ一覧 | 折りたたみ状態 |
| Metrics Properties | メトリクス設定 | 折りたたみ状態 |
| Classpath Entries | クラスパスエントリー一覧 | 折りたたみ状態 |

> **注意**: セキュリティ上、パスワードやトークン等の機密情報を含むプロパティ値は自動的にマスク（`*********(redacted)`）されて表示されます。

### 6.4 ドライバログの確認

ドライバログタブが表示されている場合（`DRIVER_LOG_LOCAL_DIR` 設定時）:

1. ナビゲーションバーの「Driver Log」タブをクリックします
2. ドライバのログファイル（driver.log / stderr / stdout）を確認できます
3. ページネーション機能で大きなログファイルも分割表示されます

---

## 7. 【STEP4-5】問題対応・処理完了（障害対応と完了確認）

> **業務フローでの位置**: 問題が発生した場合のジョブKill操作や障害対応、および正常完了時の確認を行うステップです。

### 7.1 実行中ジョブのKill操作

問題が発生した場合や、誤って投入したジョブを停止する必要がある場合にKill操作を行います。

1. 「All Jobs」画面の「Active Jobs」セクションで対象のジョブを特定します
2. ジョブのDescriptionカラムに表示される「(kill)」リンクをクリックします
3. 確認ダイアログが表示されるので「OK」をクリックします
4. ジョブがキャンセルされ、「Failed Jobs」セクションに移動します

> **注意**: Kill操作には変更権限が必要です。ACLが有効な場合、`spark.modify.acls` または `spark.admin.acls` に登録されたユーザーのみ実行可能です。`spark.ui.killEnabled` が `true`（デフォルト）の場合にKillリンクが表示されます。

### 7.2 実行中ステージのKill操作

特定のステージだけを停止する場合:

1. 「All Stages」画面で対象の「Active Stage」を特定します
2. 「(kill)」リンクをクリックします
3. 確認ダイアログで「OK」をクリックします

### 7.3 失敗ジョブの調査

ジョブが失敗した場合の調査手順:

1. 「All Jobs」画面の「Failed Jobs」セクションで失敗ジョブを確認します
2. Job Idリンクをクリックして「Job Detail」画面に遷移します
3. 「Failed Stages」セクションで失敗の原因となったステージを特定します
4. 失敗ステージの「Stage Detail」画面で以下を確認します:
   - 失敗したタスクのエラーメッセージ
   - タスクのローカリティレベル
   - メモリスピルの有無
   - シャッフルデータ量
5. 必要に応じて「Executors」画面でExecutorの状態を確認します

### 7.4 処理完了の確認

1. 「All Jobs」画面で全てのジョブが「Completed Jobs」セクションに移動していることを確認します
2. 各ジョブの実行時間（Duration）を確認します
3. 必要に応じて「Stages」画面でステージごとのメトリクスを確認します

### 7.5 History Serverでの履歴確認

アプリケーション終了後に実行履歴を確認する場合:

1. History Server（`http://<HistoryServerホスト名>:18080`）にアクセスします
2. アプリケーション一覧から対象のアプリケーションを選択します
3. 実行中のWeb UIと同じ画面構成で、ジョブ・ステージ・タスクの履歴を確認できます

> **前提条件**: イベントログの記録が有効になっている必要があります（`spark.eventLog.enabled` = `true`）。

---

## 8. SQL/DataFrameクエリ監視機能

### 8.1 SQL実行一覧の確認

Spark SQLやDataFrame APIを使用したクエリの実行状況を確認します。

> **注意**: このタブはSQLモジュールを使用しているアプリケーションでのみ表示されます。

1. ナビゲーションバーの「SQL / DataFrame」タブをクリックします
2. 「All Executions」画面が表示されます

**SQL実行テーブルの確認項目:**

| カラム | 説明 |
|--------|------|
| ID | SQL実行のID |
| Query ID | クエリID（設定時のみ表示） |
| Description | SQL文の概要（「+details」でSQL文の詳細を展開可能） |
| Submitted | 実行開始日時 |
| Duration | 実行時間 |
| Running Job IDs | 実行中のジョブIDリスト |
| Succeeded Job IDs | 成功したジョブIDリスト |
| Failed Job IDs | 失敗したジョブIDリスト |

### 8.2 SQL実行詳細の確認

1. SQL実行一覧から「ID」リンクをクリックします
2. 「SQL Execution Detail」画面で以下を確認できます:
   - **物理実行計画（Physical Plan）**: SQLの実行計画をツリー形式で表示
   - **DAGグラフ**: 実行計画のノードグラフを視覚的に表示
   - **関連ジョブ一覧**: このSQL実行に関連するSparkジョブのリスト

### 8.3 ThriftServer監視

Hive ThriftServer（JDBC/ODBC Server）を使用している場合:

1. ナビゲーションバーの「JDBC/ODBC Server」タブをクリックします
2. 「ThriftServer Overview」画面でセッション・SQL実行の統計を確認します
3. セッションIDをクリックすると、セッション詳細（ユーザー情報、IPアドレス、SQL実行履歴）を確認できます

### 8.4 Spark Connect Server監視

Spark Connect Serverを使用している場合:

1. ナビゲーションバーの「Connect」タブをクリックします
2. 「Connect Server Overview」画面でセッション・リクエストの統計を確認します
3. セッションIDをクリックすると、セッション詳細とSQL実行履歴を確認できます

---

## 9. ストリーミング処理監視機能

### 9.1 Structured Streamingクエリの監視

Structured Streamingを使用している場合のクエリ監視手順です。

> **注意**: このタブはStructured Streamingを使用しているアプリケーションでのみ表示されます。

1. ナビゲーションバーの「Streaming」タブ（または「Structured Streaming」タブ）をクリックします
2. 「Streaming Query List」画面が表示されます

**クエリ一覧の確認項目:**

| 項目 | 説明 |
|------|------|
| Active Queries | 現在実行中のストリーミングクエリ |
| Inactive Queries | 停止済みのストリーミングクエリ |

### 9.2 ストリーミングクエリ統計の確認

1. クエリ一覧からクエリIDリンクをクリックします
2. 「Streaming Query Statistics」画面で以下のグラフを確認できます:

| グラフ | 説明 | 注目ポイント |
|--------|------|------------|
| Input Rate | 入力データのレート（行数/秒） | 入力の急激な増減に注意 |
| Process Rate | 処理データのレート（行数/秒） | 入力レートを下回る場合、処理遅延が発生 |
| Batch Duration | バッチの処理時間 | バッチ間隔を超える場合は問題 |
| Operation Duration | 各オペレーションの所要時間 | ボトルネックの特定に利用 |

### 9.3 DStreams Streamingの監視

DStreams（レガシーストリーム処理）を使用している場合:

1. 「Streaming」タブをクリックします
2. 「Streaming Overview」画面で以下を確認します:
   - スケジューリング遅延のタイムライン/ヒストグラム
   - 処理時間のタイムライン/ヒストグラム
   - 総遅延のタイムライン/ヒストグラム
   - レシーバーの稼働状況・受信レート
3. バッチIDをクリックすると「Batch Detail」画面で個別バッチの詳細を確認できます

---

## 10. クラスタ管理機能（Standalone Mode）

### 10.1 Master UI（マスター概要画面）

Standalone Modeのクラスタ管理者向け画面です。

1. `http://<マスターホスト名>:8080` にアクセスします
2. 「Master Overview」画面で以下を確認します:

| セクション | 表示内容 |
|-----------|---------|
| マスター基本情報 | マスターURL、REST URL、マスターの状態（ALIVE/STANDBY等） |
| Workers | 全ワーカーのCPUコア数、メモリ、状態（Alive/Dead/Decommissioned） |
| Resources | CPUコア・メモリの使用率（使用中/総量） |
| Running Applications | 実行中のアプリケーション一覧 |
| Completed Applications | 完了したアプリケーション一覧 |
| Running Drivers | 実行中のドライバー一覧（cluster mode時） |
| Completed Drivers | 完了したドライバー一覧（cluster mode時） |

### 10.2 アプリケーションの管理

**アプリケーション詳細の確認:**

1. 「Running Applications」セクションでアプリケーションIDリンクをクリックします
2. 「Application Detail」画面でExecutorの割り当て状況を確認します

**アプリケーションのKill:**

1. 「Running Applications」セクションの「kill」リンクをクリックします（`spark.ui.killEnabled` が `true` の場合）
2. 確認ダイアログで「OK」をクリックします

> **注意**: Kill操作はSecurityManagerによる権限チェックが行われます。

### 10.3 ワーカーの管理

**ワーカーの状態確認:**

1. 「Workers」テーブルでワーカーのID、State、Cores、Memoryを確認します
2. ワーカーIDリンクをクリックすると、Worker UIに遷移します

**Worker UI（ワーカー概要画面）:**

1. `http://<ワーカーホスト名>:8081` にアクセスします（またはMaster UIからリンクで遷移）
2. 以下を確認できます:
   - ワーカーのリソース情報（Cores、Memory）
   - 実行中のExecutor一覧
   - 実行中のドライバー一覧
3. Executor/ドライバーのログ表示リンクから「Worker Log」画面に遷移し、ログファイルを確認できます

### 10.4 マスターの環境情報・ログ確認

| 画面 | アクセス方法 | 内容 |
|------|------------|------|
| Master Environment | Master UIの「Environment」リンクをクリック | JVM情報、Sparkプロパティ、Hadoopプロパティ、環境変数 |
| Master Log | Master UIの「Logs」リンクをクリック | マスターノードのログファイル |

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
====================================================================
【STEP 1】アプリケーションを投入し、Sparkジョブを開始する         --> 4章参照
    |
【STEP 2】Web UIでジョブ・ステージの実行状況をリアルタイム監視する --> 5章参照
    |
【STEP 3】リソース使用状況・メトリクスを確認し問題を特定する       --> 6章参照
    |
【STEP 4】問題発生時はジョブのKillやパラメータ調整で対応する       --> 7章参照
    |
【STEP 5】処理完了を確認し、必要に応じてHistory Serverで履歴参照   --> 7章参照
====================================================================
```

### 11.1 【データエンジニア】STEP1: アプリケーション投入

日常のバッチ処理やデータパイプラインの投入を行います。

1. `spark-submit` コマンドでアプリケーションを投入します
2. コンソールに表示されるWeb UIのURLを確認します（例: `http://localhost:4040`）
3. ブラウザでWeb UIにアクセスし、ジョブが正常に開始されたことを確認します
4. 「Active Jobs」にジョブが表示されていることを確認します

### 11.2 【データエンジニア】STEP2: ジョブの監視

アプリケーション実行中のジョブ進捗を監視します。

1. 「All Jobs」画面でジョブの進捗を確認します
2. 実行時間が想定を超えている場合は、「Job Detail」画面でステージごとの状況を確認します
3. 「Stages」タブでボトルネックとなっているステージを特定します
4. 必要に応じて「Stage Detail」画面でタスクメトリクスの分布を確認します

### 11.3 【データエンジニア/クラスタ管理者】STEP3: リソースの確認

リソースの使用状況を確認し、問題がないかチェックします。

1. 「Executors」タブでExecutorのリソース使用状況を確認します
   - Dead状態のExecutorがないか
   - 失敗タスク数が多いExecutorがないか
   - メモリ使用率が上限に近いExecutorがないか
2. 「Storage」タブでRDDのキャッシュ状況を確認します
3. 「Environment」タブで設定値が想定通りか確認します

### 11.4 【データエンジニア/クラスタ管理者】STEP4-5: 対応と完了確認

問題が発生した場合の対応と、正常完了の確認を行います。

**問題発生時:**
1. 失敗ジョブを「Job Detail」画面で調査します
2. 原因に応じてジョブのKill操作やパラメータ調整を行います
3. 修正後にアプリケーションを再投入します

**正常完了時:**
1. 全ジョブが「Completed Jobs」に移動していることを確認します
2. 実行時間が想定範囲内であることを確認します
3. アプリケーション終了後、必要に応じてHistory Serverで詳細を確認します

---

## 12. よくある質問と対処法

### 12.1 Web UIアクセスに関するQ&A

**Q: Web UIにアクセスできません**

A: 以下を確認してください:
1. Sparkアプリケーションが実行中であることを確認します
2. ファイアウォールの設定で、ポート4040（または設定されたポート）がブロックされていないか確認します
3. ホスト名が正しいか確認します。リモートからアクセスする場合は `spark.ui.port` と `spark.driver.host` の設定を確認してください
4. ポートが他のアプリケーションと競合している可能性があります。4040が使用中の場合、4041, 4042...を試してください

**Q: Web UIのページが表示されるが、データが表示されません**

A: ブラウザのJavaScriptが有効になっていることを確認してください。Executors画面などはJavaScript（DataTables）で動的にレンダリングされるため、JavaScriptが無効の場合はテーブルが表示されません。

**Q: SQLタブが表示されません**

A: SQLタブはSpark SQLやDataFrame APIを使用しているアプリケーションでのみ表示されます。RDDのみを使用している場合は表示されません。

### 12.2 ジョブ・ステージに関するQ&A

**Q: ジョブの実行が遅い場合、何を確認すべきですか?**

A: 以下の手順で調査してください:
1. 「Job Detail」画面でどのステージが時間を要しているか確認します
2. 「Stage Detail」画面の「Summary Metrics」でタスクの実行時間分布を確認します
3. Min/Max値の差が大きい場合はデータスキューの可能性があります
4. GC Timeの割合が大きい場合はメモリ不足の可能性があります
5. Shuffle Read/Write量が大きい場合はシャッフルの最適化を検討してください

**Q: ジョブをKillできません**

A: 以下を確認してください:
1. `spark.ui.killEnabled` が `true` に設定されているか確認してください（デフォルトは `true`）
2. ACLが有効な場合、`spark.modify.acls` に自分のユーザー名が登録されているか確認してください
3. ジョブが既に完了または失敗している場合はKillできません

**Q: Skipped Stagesとは何ですか?**

A: Skipped Stagesは、以前に計算済みのRDDがキャッシュされているため、再計算が不要とされスキップされたステージです。パフォーマンス最適化の結果であり、正常な動作です。

### 12.3 リソースに関するQ&A

**Q: ExecutorがDead状態になっています**

A: 以下の原因が考えられます:
1. OutOfMemoryErrorが発生してExecutorプロセスが異常終了した
2. GCの停止時間がハートビートタイムアウト（`spark.executor.heartbeatInterval`）を超過した
3. 動的リソース割り当てによりアイドルのExecutorが自動的に削除された
4. ワーカーノードのハードウェア障害

ワーカーのログを確認して原因を特定してください。

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| 症状 | 考えられる原因 | 対処法 |
|------|--------------|--------|
| 「Connection refused」でWeb UIにアクセスできない | アプリケーションが起動していない、またはポートが異なる | アプリケーションの実行状態を確認し、正しいポート番号を使用する |
| ジョブが「FAILED」状態になる | タスクの失敗、OutOfMemoryError、データの不整合等 | 「Stage Detail」画面でタスクのエラーメッセージを確認する |
| Executorが全て「Dead」 | メモリ不足、ネットワーク障害、ワーカーノードの障害 | `spark.executor.memory` を増加するか、ワーカーノードの状態を確認する |
| Web UIの表示が遅い | 大量のジョブ/ステージ/タスクデータの読み込み | ページサイズを小さくするか、History Serverのキャッシュ設定を見直す |
| 「Task not serializable」エラー | ジョブ内のオブジェクトがシリアライズできない | コード内でシリアライズ不可なオブジェクトの参照を修正する |
| 「Spill to disk」が大量に発生 | メモリ不足でデータがディスクに退避している | `spark.executor.memory` や `spark.memory.fraction` を調整する |

### 13.2 よくあるトラブルと解決方法

**トラブル1: データスキューによるタスクの偏り**

症状: 一部のタスクだけが非常に長時間実行されている

調査方法:
1. 「Stage Detail」画面で「Summary Metrics」のDuration（Min/25th/Median/75th/Max）を確認します
2. Max値がMedianの数倍以上の場合、データスキューが発生しています

対処法:
- データの再パーティショニングを検討してください
- Adaptive Query Execution（AQE）の `spark.sql.adaptive.skewJoin.enabled` を有効にしてください
- Salting（キーにランダム値を付加）を適用してください

**トラブル2: OutOfMemoryによるExecutor障害**

症状: Executorが頻繁にDead状態になる

調査方法:
1. 「Executors」画面でDead状態のExecutorを確認します
2. ワーカーのログでOutOfMemoryErrorを確認します
3. 「Stage Detail」でMemory Spillの量を確認します

対処法:
- `spark.executor.memory` を増加してください
- `spark.executor.memoryOverhead` を増加してください（コンテナ環境の場合）
- データのパーティション数を増やして各タスクの処理データ量を減らしてください

**トラブル3: シャッフルデータ量が大きすぎる**

症状: ステージの実行時間の大部分がShuffle Readに費やされている

調査方法:
1. 「Stage Detail」画面の「Summary Metrics」でShuffle Read Sizeを確認します
2. 「Shuffle Read Blocked Time」が大きい場合、データの転送がボトルネックになっています

対処法:
- シャッフル前にデータをフィルタリングしてデータ量を削減してください
- `spark.sql.shuffle.partitions` の値を調整してください（デフォルト200）
- ブロードキャスト結合を検討してください（小さなテーブルとの結合時）

### 13.3 サポートへの連絡方法

問題が解決しない場合は、以下の情報を添えてApache Sparkコミュニティまたは社内のサポート担当に連絡してください:

1. **アプリケーションID**: `spark.app.id` の値
2. **エラーメッセージ**: 「Stage Detail」画面のタスクエラーメッセージ
3. **環境情報**: 「Environment」画面のスクリーンショットまたはエクスポート
4. **イベントログ**: `spark.eventLog.dir` に保存されたイベントログファイル
5. **ドライバ/Executorログ**: アプリケーションの標準出力・エラー出力ログ

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-02-04 | 初版作成 |

---

*本マニュアルは、Apache Spark Web UIのエンドユーザー向け業務運用マニュアルです。*
*Sparkのバージョンアップにより、画面や操作方法が変更される場合があります。*
