---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 60
  claims_with_evidence: 56
  claims_without_evidence: 4
confidence_derived: 0.93
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：56 / 60、根拠なし：4
- 優先レビュー（高）
  1. **NFT-043 YARNリソースマネージャ互換性確認**：具体的な設定値の根拠不足（モジュール存在のみ）
  2. **NFT-044 Standaloneクラスタ互換性確認**：具体的な設定値の根拠不足（モジュール存在のみ）
  3. **NFT-013 同時タスク大量実行テスト**：合格基準の具体的な数値根拠が不足
  4. **NFT-012 オフヒープメモリ有効化テスト**：具体的なサイズの合格基準が未定義

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/scala/org/apache/spark/internal/config/Network.scala` - ネットワーク関連設定定義
- E-02: `core/src/main/scala/org/apache/spark/internal/config/package.scala` - 主要設定パラメータ定義
- E-03: `core/src/main/scala/org/apache/spark/SecurityManager.scala` - セキュリティマネージャ実装
- E-04: `core/src/main/scala/org/apache/spark/SSLOptions.scala` - SSL設定オプション
- E-05: `core/src/main/scala/org/apache/spark/ExecutorAllocationManager.scala` - 動的リソースアロケーション
- E-06: `core/src/main/scala/org/apache/spark/HeartbeatReceiver.scala` - ハートビート受信
- E-07: `conf/metrics.properties.template` - メトリクスシステム設定テンプレート
- E-08: `conf/spark-defaults.conf.template` - Sparkデフォルト設定テンプレート
- E-09: `core/src/main/scala/org/apache/spark/internal/config/UI.scala` - UI/ACL設定定義
- E-10: `core/src/main/scala/org/apache/spark/metrics/MetricsSystem.scala` - メトリクスシステム実装
- E-11: `resource-managers/kubernetes/` - Kubernetesリソースマネージャモジュール
- E-12: `resource-managers/yarn/` - YARNリソースマネージャモジュール
- E-13: `core/src/main/scala/org/apache/spark/deploy/master/` - Standaloneマスター実装
- E-14: `docs/code-to-docs/非機能要件定義書/非機能要件定義書.md` - 既存の非機能要件定義書
- E-15: `core/src/main/scala/org/apache/spark/internal/config/Deploy.scala` - デプロイ設定定義
- E-16: `core/src/main/scala/org/apache/spark/storage/BlockReplicationPolicy.scala` - ブロックレプリケーションポリシー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001: ネットワークタイムアウト120秒 | E-01, E-14 | ○ |
| C-02 | NFT-002: RPCメッセージ最大サイズ128MB | E-01, E-14 | ○ |
| C-03 | NFT-003: Executorハートビート間隔10秒 | E-06, E-14 | ○ |
| C-04 | NFT-004: BlockManagerタイムアウト60秒 | E-02, E-14 | ○ |
| C-05 | NFT-005: Shuffleサービス登録タイムアウト5秒 | E-02, E-14 | ○ |
| C-06 | NFT-006: RPC接続スレッド64 | E-01, E-14 | ○ |
| C-07 | NFT-007: リモートブロックフェッチメモリ上限200MB | E-02, E-14 | ○ |
| C-08 | NFT-008: ドライバ最大結果サイズ1GB | E-02, E-14 | ○ |
| C-09 | NFT-009: ドライバメモリ1GB | E-02, E-14 | ○ |
| C-10 | NFT-010: Executorメモリ1GB | E-02, E-14 | ○ |
| C-11 | NFT-011: メモリオーバーヘッド比率10% | E-02, E-14 | ○ |
| C-12 | NFT-012: オフヒープメモリ有効化 | E-02 | △ |
| C-13 | NFT-013: 同時タスク大量実行・バックログ1秒 | E-05, E-14 | △ |
| C-14 | NFT-014: ZooKeeper接続タイムアウト15秒 | E-14 | ○ |
| C-15 | NFT-015: ZooKeeper再接続3回・5秒間隔 | E-14 | ○ |
| C-16 | NFT-016: タスク最大失敗回数4回 | E-02, E-14 | ○ |
| C-17 | NFT-017: Executor最大リトライ10回 | E-02, E-14 | ○ |
| C-18 | NFT-018: Shuffleサービス登録リトライ3回 | E-02, E-14 | ○ |
| C-19 | NFT-019: Executorハートビート最大失敗60回 | E-02, E-14 | ○ |
| C-20 | NFT-020: 動的アロケーション最小Executor数0 | E-05, E-14 | ○ |
| C-21 | NFT-021: Executorアイドルタイムアウト60秒 | E-05, E-14 | ○ |
| C-22 | NFT-022: キャッシュ済Executorアイドルタイムアウト無制限 | E-05, E-14 | ○ |
| C-23 | NFT-023: ブロック積極的レプリケーション | E-02, E-16, E-14 | ○ |
| C-24 | NFT-024: ブロック失敗時ロケーションリフレッシュ5回 | E-02, E-14 | ○ |
| C-25 | NFT-025: ネットワーク認証有効化 | E-03, E-02, E-14 | ○ |
| C-26 | NFT-026: 認証秘密鍵256ビット | E-02, E-14 | ○ |
| C-27 | NFT-027: SASL認証ユーザーsparkSaslUser | E-03, E-14 | ○ |
| C-28 | NFT-028: ネットワーク暗号化（AES） | E-01, E-14 | ○ |
| C-29 | NFT-029: I/O暗号化有効化 | E-02, E-14 | ○ |
| C-30 | NFT-030: I/O暗号化キーサイズ128ビット | E-02, E-14 | ○ |
| C-31 | NFT-031: RPC SSL有効化 | E-03, E-04, E-14 | ○ |
| C-32 | NFT-032: SSL相互認証needClientAuth | E-04, E-14 | ○ |
| C-33 | NFT-033: SASL暗号化フォールバック | E-01, E-14 | ○ |
| C-34 | NFT-034: UI ACL有効化 | E-09, E-03, E-14 | ○ |
| C-35 | NFT-035: 管理者ACL | E-03, E-14 | ○ |
| C-36 | NFT-036: 閲覧権限ACL | E-03, E-09, E-14 | ○ |
| C-37 | NFT-037: 変更権限ACL | E-03, E-14 | ○ |
| C-38 | NFT-038: ワイルドカードACL | E-03, E-14 | ○ |
| C-39 | NFT-039: 機密情報リダクション | E-02, E-14 | ○ |
| C-40 | NFT-040: SQLリダクション | E-02, E-14 | ○ |
| C-41 | NFT-041: Kubernetes環境ドライバ起動 | E-11, E-14 | ○ |
| C-42 | NFT-042: Kubernetes環境Executor起動 | E-11, E-14 | ○ |
| C-43 | NFT-043: YARNリソースマネージャ互換性 | E-12 | △ |
| C-44 | NFT-044: Standaloneクラスタ互換性 | E-13 | △ |
| C-45 | NFT-045: Shuffleチェックサム有効化 | E-02, E-14 | ○ |
| C-46 | NFT-046: Shuffleチェックサムアルゴリズム | E-02, E-14 | ○ |
| C-47 | NFT-047: Shuffle圧縮有効化 | E-02, E-14 | ○ |
| C-48 | NFT-048: Executor失敗除外機能 | E-02, E-14 | ○ |
| C-49 | NFT-049: Executor単位タスク失敗回数制限 | E-02, E-14 | ○ |
| C-50 | NFT-050: タスクリーパー | E-02, E-14 | ○ |
| C-51 | NFT-051: メトリクスシステムMetricsServlet | E-07, E-10, E-14 | ○ |
| C-52 | NFT-052: Prometheusメトリクスエンドポイント | E-07, E-14 | ○ |
| C-53 | NFT-053: JVMソースメトリクス | E-07, E-14 | ○ |
| C-54 | NFT-054: Executorメトリクスポーリング | E-02, E-14 | ○ |
| C-55 | NFT-055: 構造化ログ出力 | E-02, E-14 | ○ |
| C-56 | NFT-056: イベントログ有効化 | E-02, E-14 | ○ |
| C-57 | NFT-057: 遅延イベントログ | E-02, E-14 | ○ |
| C-58 | NFT-058: セキュリティクレデンシャル自動更新 | E-02, E-14 | ○ |
| C-59 | NFT-059: セキュリティクレデンシャル更新リトライ | E-02, E-14 | ○ |
| C-60 | NFT-060: Executor安全停止デコミッション | E-02, E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- NFT-012（オフヒープメモリ有効化テスト）：具体的なサイズの合格基準が環境依存であり、汎用的な基準値が定義されていない
  - 候補：実運用環境のメモリ構成仕様書 / インフラ設計書 / ベンチマーク結果
- NFT-013（同時タスク大量実行テスト）：ストレステストの「大量」の定義が不明確。具体的なタスク数やデータ量の基準がない
  - 候補：性能テスト計画書 / ベンチマーク仕様書 / SLA定義書
- NFT-043（YARNリソースマネージャ互換性）：YARNモジュールの存在は確認できるが、具体的なテスト条件・合格基準の詳細根拠が不足
  - 候補：YARNクラスタ環境仕様書 / YARN統合テスト仕様書
- NFT-044（Standaloneクラスタ互換性）：Standaloneモジュールの存在は確認できるが、具体的なテスト条件・合格基準の詳細根拠が不足
  - 候補：Standalone環境構成書 / 統合テスト仕様書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 性能テスト（NFT-001～008）、セキュリティテスト（NFT-025～040）のテストケースはソースコードの設定値から直接導出されており、根拠が明確
- 1: 中リスク - 負荷テスト（NFT-009～012）およびストレステスト（NFT-013）は、合格基準がデフォルト設定値に基づくが、実運用環境のリソース制約により結果が異なる可能性がある
- 1: 中リスク - 互換性テスト（NFT-041～044）は、特定のクラスタ環境（Kubernetes/YARN/Standalone）が必要であり、テスト環境の構築条件が未定義
- 0: 低リスク - 可用性テスト（NFT-014～024, NFT-058～059）は、設定値とリトライロジックがソースコードで確認でき、テスト条件が明確
- 0: 低リスク - 保守性テスト（NFT-045～060）は、設定パラメータと機能が明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] 性能テスト（NFT-001～008）の合格基準値がソースコードの設定デフォルト値と一致しているか
- [ ] 負荷テスト（NFT-009～013）の合格基準が実運用環境の要件と整合しているか
- [ ] 可用性テスト（NFT-014～024）のリトライ回数・タイムアウト値がソースコードと一致しているか
- [ ] セキュリティテスト（NFT-025～040）のテスト条件が実際のセキュリティ要件をカバーしているか
- [ ] 互換性テスト（NFT-041～044）のテスト環境要件が明確に定義されているか
- [ ] 保守性テスト（NFT-045～060）の監視・ログ・データ整合性テストが網羅的か
- [ ] 全テストケースの優先度設定が適切か（高：サービスに直接影響、中：運用に影響、低：最適化レベル）
