---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 39
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：39 / 42、根拠なし：3
- 優先レビュー（高）
  1. **稼働率・RPO/RTOの具体的数値目標**：フレームワーク特性上コードに明示なし
  2. **Kubernetesタイムアウト値の具体的デフォルト値**：コード内で確認したが値の記載形式が複雑
  3. **プロダクション環境でのセキュリティ推奨設定**：ベストプラクティスとしての推奨であり、コードからの直接的根拠ではない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/scala/org/apache/spark/internal/config/Network.scala` - ネットワークタイムアウト、RPC設定
- E-02: `core/src/main/scala/org/apache/spark/internal/config/package.scala` - 各種設定定義（タイムアウト、メモリ、リトライ、セキュリティ等）
- E-03: `core/src/main/scala/org/apache/spark/SecurityManager.scala` - 認証・暗号化・ACL管理
- E-04: `core/src/main/scala/org/apache/spark/internal/config/Deploy.scala` - デプロイ・リカバリ設定
- E-05: `core/src/main/scala/org/apache/spark/deploy/SparkCuratorUtil.scala` - ZooKeeper接続設定
- E-06: `conf/metrics.properties.template` - メトリクスシンク設定
- E-07: `conf/log4j2.properties.template` - ログ設定
- E-08: `conf/spark-env.sh.template` - 環境変数設定
- E-09: `conf/spark-defaults.conf.template` - デフォルト設定テンプレート
- E-10: `conf/fairscheduler.xml.template` - フェアスケジューラ設定
- E-11: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/Config.scala` - Kubernetes設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ネットワークタイムアウトのデフォルト値は120秒 | E-01 (L42-46) | ○ |
| C-02 | RPCメッセージ最大サイズのデフォルト値は128MB | E-01 (L84-88) | ○ |
| C-03 | Executorハートビート間隔のデフォルト値は10秒 | E-02 (L348-352) | ○ |
| C-04 | ブロックマネージャタイムアウトのデフォルト値は60秒 | E-02 (L661-665) | ○ |
| C-05 | ドライバハートビートタイムアウトのデフォルト値は10分 | E-02 (L667-672) | ○ |
| C-06 | Shuffleサービス登録タイムアウトのデフォルト値は5000ms | E-02 (L1436-1441) | ○ |
| C-07 | バリア同期タイムアウトのデフォルト値は365日 | E-02 (L1855-1864) | ○ |
| C-08 | スケジュール不可タスクセットタイムアウトのデフォルト値は120秒 | E-02 (L1866-1874) | ○ |
| C-09 | ドライバタイムアウトのデフォルト値は0分（無制限） | E-02 (L1198-1205) | ○ |
| C-10 | RPC接続スレッド数のデフォルト値は64 | E-01 (L60-64) | ○ |
| C-11 | ドライバメモリのデフォルト値は1GB | E-02 (L119-123) | ○ |
| C-12 | ドライバコア数のデフォルト値は1 | E-02 (L113-117) | ○ |
| C-13 | ドライバメモリオーバーヘッド最小値は384MB | E-02 (L132-138) | ○ |
| C-14 | ドライバメモリオーバーヘッド比率は0.10 | E-02 (L140-154) | ○ |
| C-15 | 復旧モードのデフォルトはNONE | E-04 (L24-27) | ○ |
| C-16 | ZooKeeper接続タイムアウトは15秒 | E-05 (L32) | ○ |
| C-17 | ZooKeeperセッションタイムアウトは60秒 | E-05 (L33) | ○ |
| C-18 | ZooKeeper再接続リトライ間隔は5秒、最大3回 | E-05 (L34-35) | ○ |
| C-19 | ドライバ自動再起動はデフォルト無効 | E-02 (L1191-1196) | ○ |
| C-20 | タスク最大失敗回数のデフォルト値は4回 | E-02 (L926-930) | ○ |
| C-21 | Executor最大リトライ回数のデフォルト値は10回 | E-04 (L81-84) | ○ |
| C-22 | Shuffleサービス登録最大試行回数のデフォルト値は3回 | E-02 (L1443-1449) | ○ |
| C-23 | Executorハートビート最大失敗回数のデフォルト値は60回 | E-02 (L354-359) | ○ |
| C-24 | 動的アロケーションはデフォルト無効 | E-02 (L716-720) | ○ |
| C-25 | ネットワーク認証はデフォルト無効 | E-02 (L1318-1322), E-03 (L58) | ○ |
| C-26 | 認証秘密鍵ビット長は256ビット | E-02 (L1312-1316) | ○ |
| C-27 | ネットワーク暗号化はデフォルト無効 | E-01 (L30-34) | ○ |
| C-28 | I/O暗号化はデフォルト無効 | E-02 (L1155-1158) | ○ |
| C-29 | I/O暗号化キーサイズのデフォルトは128ビット | E-02 (L1166-1170) | ○ |
| C-30 | I/O暗号化方式はAES/CTR/NoPadding | E-02 (L1172-1177) | ○ |
| C-31 | RPC SSLはデフォルト無効 | E-03 (L89-90) | ○ |
| C-32 | ACLはデフォルト無効 | E-03 (L59) | ○ |
| C-33 | 機密情報リダクションのデフォルトパターン | E-02 (L1287-1295) | ○ |
| C-34 | Shuffleチェックサムはデフォルト有効 | E-02 (L1664-1673) | ○ |
| C-35 | チェックサムアルゴリズムのデフォルトはADLER32 | E-02 (L1675-1683) | ○ |
| C-36 | メトリクスのインスタンス種別（master, worker, executor, driver, applications） | E-06 (L23-25) | ○ |
| C-37 | MetricsServletのデフォルトパスは/metrics/json | E-06 (L105-114) | ○ |
| C-38 | PrometheusServletのデフォルトパスは/metrics/prometheus | E-06 (L116-123) | ○ |
| C-39 | ログレベルのデフォルトはINFO、出力先はSYSTEM_ERR | E-07 (L19-32) | ○ |
| C-40 | 稼働率（SLA）の具体的数値はデプロイ環境依存 | **根拠なし** | △ |
| C-41 | Kubernetesタイムアウトのデフォルト値の具体値 | E-11 (概要確認のみ) | △ |
| C-42 | プロダクション環境でのセキュリティ有効化推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-40: Apache Sparkはフレームワークであるため、稼働率・RPO/RTOなどのSLA数値はコードベースに定義されていない。これらはデプロイ先のインフラストラクチャとSLA契約に依存する。
  - 候補：運用チームのSLA定義書 / クラウドプロバイダのSLA / 社内SLA基準
- C-41: Kubernetes関連のタイムアウト設定はConfig.scalaに定義されているが、一部の設定はデフォルト値が明示されておらず、ランタイム依存の可能性がある。
  - 候補：Kubernetes Config.scala の詳細解析 / Kubernetes公式ドキュメント / Sparkの公式ドキュメント
- C-42: プロダクション環境でのセキュリティ有効化推奨は一般的なベストプラクティスであり、コードから直接導出されたものではない。
  - 候補：Apache Spark公式セキュリティガイド / CISベンチマーク / 社内セキュリティポリシー

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 性能要件のデフォルト値はコードから直接確認済み
- 0: 低リスク - セキュリティ設定のデフォルト値はSecurityManager.scalaおよびconfig/package.scalaから確認済み
- 1: 中リスク - 可用性要件の一部（稼働率等）はインフラ依存であり、コードからの根拠が不足
- 1: 中リスク - Kubernetes固有設定の一部デフォルト値が未確認
- 0: 低リスク - メトリクス・監視設定はmetrics.properties.templateから直接確認済み
- 2: 高リスク - セキュリティ機能がデフォルトで多数無効化されているため、プロダクション環境でのセキュリティ設定レビューは必須

## 6) レビュアーチェックリスト（最小）
- [ ] 性能要件のタイムアウト値がプロジェクトの要件と合致しているか確認
- [ ] セキュリティ要件（認証・暗号化・ACL）がプロダクション環境の要件を満たしているか確認
- [ ] 動的リソースアロケーションの設定がワークロードに適切か確認
- [ ] ZooKeeperベースのHA構成が必要な場合、リカバリモードの設定を確認
- [ ] メトリクスの出力先（シンク）がモニタリング基盤と連携しているか確認
- [ ] Kubernetes環境固有のタイムアウト設定が適切か確認
- [ ] 稼働率・RPO/RTO等のSLA要件がインフラ設計書と整合しているか確認
