# 非機能要件定義書

## 概要

本ドキュメントは、Apache Sparkプロジェクトにおける非機能要件を定義するものである。プロジェクトのソースコード（設定定義、セキュリティ管理、メトリクス設定、リソース管理設定等）から抽出した、性能・可用性・セキュリティ・拡張性・保守性・運用監視に関する要件をまとめている。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| ネットワークタイムアウト（全般） | 120秒以内 | `spark.network.timeout` のデフォルト値。RPC通信・ブロック転送等の全般的なタイムアウト基準 |
| RPCメッセージ最大サイズ | 128MB | `spark.rpc.message.maxSize` のデフォルト値。RPC通信における1メッセージの上限 |
| Executorハートビート間隔 | 10秒 | `spark.executor.heartbeatInterval` のデフォルト値。Executor生存確認の間隔 |
| ブロックマネージャタイムアウト | 60秒 | `spark.storage.blockManagerTimeoutIntervalMs` のデフォルト値 |
| ドライバハートビートタイムアウト | 10分 | `spark.storage.blockManagerMasterDriverHeartbeatTimeoutMs` のデフォルト値 |
| Shuffleサービス登録タイムアウト | 5秒（5000ms） | `spark.shuffle.registration.timeout` のデフォルト値 |
| バリア同期タイムアウト | 365日（31,536,000秒） | `spark.barrier.sync.timeout` のデフォルト値。バリアタスク間の同期待ち上限 |
| スケジュール不可タスクセットタイムアウト | 120秒 | `spark.scheduler.excludeOnFailure.unschedulableTaskSetTimeout` のデフォルト値 |
| ドライバタイムアウト | 0分（無制限） | `spark.driver.timeout` のデフォルト値。0は無制限を意味する |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| RPC接続スレッド数 | 64 | `spark.rpc.connect.threads` のデフォルト値 |
| ピア間RPC接続数 | 1 | `spark.rpc.io.numConnectionsPerPeer` のデフォルト値 |
| リモートブロック同時フェッチ上限 | 無制限（Int.MaxValue） | `spark.reducer.maxBlocksInFlightPerAddress` のデフォルト値。ノードマネージャの負荷軽減のため下方調整を推奨 |
| Shuffleファイルバッファサイズ | 32KB | `spark.shuffle.file.buffer` のデフォルト値 |
| リモートブロックのメモリフェッチ上限 | 200MB | `spark.network.maxRemoteBlockSizeFetchToMem` のデフォルト値。超過分はディスクフェッチに切替 |
| ドライバ最大結果サイズ | 1GB | `spark.driver.maxResultSize` のデフォルト値 |

### リソース割り当て

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| ドライバメモリ | 1GB | `spark.driver.memory` のデフォルト値 |
| ドライバコア数 | 1 | `spark.driver.cores` のデフォルト値（クラスタモード時） |
| Executorメモリ | 1GB | `SPARK_EXECUTOR_MEMORY` のデフォルト値 |
| Executorコア数 | 1 | `SPARK_EXECUTOR_CORES` のデフォルト値 |
| ドライバメモリオーバーヘッド最小値 | 384MB | `spark.driver.minMemoryOverhead` のデフォルト値 |
| ドライバメモリオーバーヘッド比率 | 0.10（10%） | `spark.driver.memoryOverheadFactor` のデフォルト値。Kubernetes非JVMジョブでは0.40 |
| タスクあたりCPU数 | 1 | `spark.task.cpus` のデフォルト値 |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 高可用性（HA）復旧モード | NONE（デフォルト） | `spark.deploy.recoveryMode` で ZOOKEEPER / FILESYSTEM に変更可能 |
| ZooKeeper接続タイムアウト | 15秒 | `SparkCuratorUtil.ZK_CONNECTION_TIMEOUT_MILLIS` で定義 |
| ZooKeeperセッションタイムアウト | 60秒 | `SparkCuratorUtil.ZK_SESSION_TIMEOUT_MILLIS` で定義 |
| ZooKeeper再接続リトライ間隔 | 5秒 | `SparkCuratorUtil.RETRY_WAIT_MILLIS` で定義。指数バックオフ方式 |
| ZooKeeper最大再接続試行回数 | 3回 | `SparkCuratorUtil.MAX_RECONNECT_ATTEMPTS` で定義 |
| ドライバ自動再起動 | 無効（デフォルト） | `spark.driver.supervise` で有効化可能（Standaloneモードのみ） |
| タスク最大失敗回数 | 4回 | `spark.task.maxFailures` のデフォルト値 |
| Executor最大リトライ回数 | 10回 | `spark.deploy.maxExecutorRetries` のデフォルト値 |
| Shuffleサービス登録最大試行回数 | 3回 | `spark.shuffle.registration.maxAttempts` のデフォルト値 |
| Shuffle Netty OOM最大リトライ回数 | 10回 | `spark.shuffle.maxAttemptsOnNettyOOM` のデフォルト値 |
| Executorハートビート最大失敗回数 | 60回 | `spark.executor.heartbeat.maxFailures` のデフォルト値 |
| 動的リソースアロケーション | 無効（デフォルト） | `spark.dynamicAllocation.enabled` で有効化可能 |
| 動的アロケーション最小Executor数 | 0 | `spark.dynamicAllocation.minExecutors` のデフォルト値 |
| 動的アロケーション最大Executor数 | 無制限（Int.MaxValue） | `spark.dynamicAllocation.maxExecutors` のデフォルト値 |
| 動的アロケーションExecutorアイドルタイムアウト | 60秒 | `spark.dynamicAllocation.executorIdleTimeout` のデフォルト値 |
| キャッシュ済Executorアイドルタイムアウト | 無制限（Int.MaxValue秒） | `spark.dynamicAllocation.cachedExecutorIdleTimeout` のデフォルト値 |
| セキュリティクレデンシャル更新リトライ待機 | 1時間 | `spark.security.credentials.retryWait` のデフォルト値 |
| セキュリティクレデンシャル更新比率 | 0.75（75%） | `spark.security.credentials.renewalRatio` のデフォルト値。有効期限の75%到達時に更新 |
| ブロック失敗時のロケーションリフレッシュ閾値 | 5回 | `spark.block.failures.beforeLocationRefresh` のデフォルト値 |
| ストレージブロック積極的レプリケーション | 有効 | `spark.storage.replication.proactive` で設定。ブロックのレプリカ数を維持 |

## セキュリティ要件

### 認証

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| ネットワーク認証 | 無効（デフォルト） | `spark.authenticate` で有効化可能 |
| 認証秘密鍵のビット長 | 256ビット | `spark.authenticate.secretBitLength` のデフォルト値 |
| 認証秘密鍵ファイル | Kubernetesモード限定 | `spark.authenticate.secret.file` で指定。Kubernetes環境のみファイルベースの鍵を許可 |
| SASL認証ユーザー | `sparkSaslUser`（固定） | SecurityManagerで定義されたハードコード値 |

### 暗号化

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| ネットワーク暗号化（AES） | 無効（デフォルト） | `spark.network.crypto.enabled` で有効化可能 |
| SASL暗号化 | 無効（デフォルト） | `spark.authenticate.enableSaslEncryption` で有効化可能 |
| SASL暗号化フォールバック | 有効（デフォルト） | `spark.network.crypto.saslFallback` のデフォルト値 |
| I/O暗号化 | 無効（デフォルト） | `spark.io.encryption.enabled` で有効化可能 |
| I/O暗号化キーサイズ | 128ビット | `spark.io.encryption.keySizeBits` のデフォルト値。128/192/256ビットから選択可能 |
| I/O暗号化キー生成アルゴリズム | HmacSHA1 | `spark.io.encryption.keygen.algorithm` のデフォルト値 |
| I/O暗号化方式 | AES/CTR/NoPadding | `spark.io.crypto.cipher.transformation` のデフォルト値 |
| RPC SSL | 無効（デフォルト） | `spark.ssl.rpc.enabled` で有効化可能。有効時はネットワーク暗号化は自動無効化 |
| SSL設定 | モジュール別設定可能 | `spark.ssl.<module>` で各モジュール（RPC等）ごとにSSL設定を定義可能 |

### アクセス制御（ACL）

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| UI ACL | 無効（デフォルト） | `spark.acls.enable` で有効化可能 |
| 管理者ACL | 設定可能 | `spark.admin.acls` でユーザー、`spark.admin.acls.groups` でグループを指定 |
| 閲覧権限ACL | 設定可能 | `spark.ui.view.acls` でユーザー、`spark.ui.view.acls.groups` でグループを指定 |
| 変更権限ACL | 設定可能 | `spark.modify.acls` でユーザー、`spark.modify.acls.groups` でグループを指定 |
| ワイルドカードACL | `*` で全ユーザーアクセス許可 | 管理者/閲覧/変更いずれでも使用可能 |

### 情報保護

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| 機密情報のリダクション | 有効 | `spark.redaction.regex` のデフォルトパターン: `(?i)secret\|password\|token\|access[.]?key` |
| リダクション対象 | 環境変数、ログ、イベントログ | プロパティキーまたは値がパターンに合致した場合に自動リダクション |
| SQLリダクション | 設定可能 | `spark.redaction.string.regex` でSQL Explainコマンドの出力をリダクション可能 |

## 拡張性要件

### 動的リソースアロケーション

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| 動的アロケーション有効化 | 無効（デフォルト） | `spark.dynamicAllocation.enabled` で制御 |
| Executor割り当て比率 | 1.0 | `spark.dynamicAllocation.executorAllocationRatio` のデフォルト値 |
| スケジューラバックログタイムアウト | 1秒 | `spark.dynamicAllocation.schedulerBacklogTimeout` のデフォルト値 |
| Shuffleトラッキング | 有効（デフォルト） | `spark.dynamicAllocation.shuffleTracking.enabled` のデフォルト値 |

### スケーリング構成

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| ワーカー選択ポリシー | CORES_FREE_DESC | `spark.deploy.workerSelectionPolicy` のデフォルト値。空きコア数の多いワーカーを優先 |
| アプリケーション分散配置 | 有効 | `spark.deploy.spreadOutApps` のデフォルト値 |
| ドライバ分散配置 | 有効 | `spark.deploy.spreadOutDrivers` のデフォルト値 |
| 最大同時ドライバ数 | 無制限（Int.MaxValue） | `spark.deploy.maxDrivers` のデフォルト値 |
| フェアスケジューラ | 設定可能 | `fairscheduler.xml` でプール単位のスケジューリングモード（FAIR/FIFO）、重み、最小シェアを定義可能 |

### Kubernetesスケーリング

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| ドライバ起動リクエストタイムアウト | 設定可能 | `spark.kubernetes.submission.requestTimeout` で指定 |
| ドライバ起動接続タイムアウト | 設定可能 | `spark.kubernetes.submission.connectionTimeout` で指定 |
| Executorリクエストタイムアウト | 設定可能 | `spark.kubernetes.driver.requestTimeout` で指定 |
| Executor接続タイムアウト | 設定可能 | `spark.kubernetes.driver.connectionTimeout` で指定 |

## 保守性要件

### データ整合性

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| Shuffleチェックサム | 有効（デフォルト） | `spark.shuffle.checksum.enabled` のデフォルト値 |
| チェックサムアルゴリズム | ADLER32 | `spark.shuffle.checksum.algorithm` のデフォルト値。CRC32、CRC32Cも選択可能 |
| Shuffle圧縮 | 有効（デフォルト） | `spark.shuffle.compress` のデフォルト値 |
| Shuffleスピル圧縮 | 有効（デフォルト） | `spark.shuffle.spill.compress` のデフォルト値 |

### フォールトトレランス

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| タスク最大失敗回数 | 4回 | `spark.task.maxFailures` のデフォルト値。超過時にジョブ失敗 |
| Executor失敗除外機能 | 無効（デフォルト） | `spark.excludeOnFailure.enabled` で有効化可能 |
| Executor単位の最大タスク失敗回数 | 1回 | `spark.excludeOnFailure.task.maxTaskAttemptsPerExecutor` のデフォルト値 |
| ノード単位の最大タスク失敗回数 | 2回 | `spark.excludeOnFailure.task.maxTaskAttemptsPerNode` のデフォルト値 |
| アプリケーション全体のExecutor単位最大失敗回数 | 2回 | `spark.excludeOnFailure.application.maxFailedTasksPerExecutor` のデフォルト値 |
| ノード単位の最大失敗Executor数 | 2 | `spark.excludeOnFailure.application.maxFailedExecutorsPerNode` のデフォルト値 |
| タスクリーパー | 無効（デフォルト） | `spark.task.reaper.enabled` で有効化可能。停止不可タスクの強制終了 |
| タスクリーパーポーリング間隔 | 10秒 | `spark.task.reaper.pollingInterval` のデフォルト値 |
| Executor終了時ファイルクリーンアップ | 有効 | `spark.storage.cleanupFilesAfterExecutorExit` のデフォルト値 |

### 構造化ログ

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| 構造化ログ出力 | 無効（デフォルト） | `spark.log.structuredLogging.enabled` で有効化。JSON形式でMDC付きログ出力 |
| デフォルトログレベル | INFO | `log4j2.properties.template` の `rootLogger.level = info` で定義 |
| ログ出力先 | SYSTEM_ERR（コンソール） | Log4j2のConsoleアペンダーで定義 |
| ログパターン | `%d{yy/MM/dd HH:mm:ss} %p %c{1}: %m%n%ex` | パフォーマンスを考慮し `%xEx`（パッケージ情報付き）ではなく `%ex` を使用 |
| 最大ログファイル数 | 5 | `SPARK_LOG_MAX_FILES` のデフォルト値 |

## 運用・監視要件

### メトリクスシステム

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| メトリクスインスタンス | master, worker, executor, driver, applications | 各コンポーネント別にメトリクスを収集可能 |
| 内部ソース | MasterSource, WorkerSource等 | 各インスタンスに自動追加 |
| 共通ソース | JvmSource | JVM関連メトリクス収集。設定で追加可能 |
| ExecutorMetricsSource | 有効（デフォルト） | `spark.metrics.executorMetricsSource.enabled` のデフォルト値 |
| Executorメトリクスポーリング間隔 | 0（ハートビート時） | `spark.executor.metrics.pollingInterval` のデフォルト値。0の場合はハートビート契機で収集 |
| プロセスツリーメトリクス | 無効（デフォルト） | `spark.executor.processTreeMetrics.enabled` のデフォルト値。/procからのメトリクス収集 |

### メトリクスシンク（出力先）

| シンク | 設定 | 備考 |
| --- | --- | --- |
| ConsoleSink | ポーリング間隔: 10秒 | コンソールへのメトリクス出力 |
| CSVSink | ポーリング間隔: 10秒、出力先: /tmp | CSVファイルへのメトリクス出力 |
| JmxSink | 設定のみ | JMX経由のメトリクス公開 |
| MetricsServlet | パス: /metrics/json | HTTP経由のJSON形式メトリクス取得。デフォルトで有効 |
| PrometheusServlet | パス: /metrics/prometheus | Prometheus形式のメトリクスエンドポイント |
| GraphiteSink | ポーリング間隔: 10秒、プロトコル: TCP | Graphiteサーバーへのメトリクス送信 |
| StatsdSink | ホスト: 127.0.0.1、ポート: 8125、ポーリング間隔: 10秒 | StatsD形式のメトリクス送信 |
| Slf4jSink | 設定のみ | SLF4Jログフレームワーク経由のメトリクス出力 |

### イベントログ・履歴

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| イベントログ | 設定可能 | `spark.eventLog.enabled` で有効化。`spark.eventLog.dir` でHDFS等への出力先指定 |
| 保持アプリケーション数 | 200 | `spark.deploy.retainedApplications` のデフォルト値 |
| 保持ドライバ数 | 200 | `spark.deploy.retainedDrivers` のデフォルト値 |
| ドライバログDFS保存 | 無効（デフォルト） | `spark.driver.log.persistToDfs.enabled` のデフォルト値 |

### リスナーバスイベント監視

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| 遅延イベントログ | 有効（デフォルト） | `spark.scheduler.listenerbus.logSlowEvent` のデフォルト値 |
| 遅延イベント閾値 | 1秒 | `spark.scheduler.listenerbus.logSlowEvent.threshold` のデフォルト値 |
| リスナーバス終了タイムアウト | 0（即時） | `spark.scheduler.listenerbus.exitTimeout` のデフォルト値 |

## 備考

- 本ドキュメントで記載の設定値はソースコード上のデフォルト値である。実運用環境ではワークロードや要件に応じた適切なチューニングが必要となる。
- Apache Sparkはフレームワークであるため、稼働率（SLA）等の具体的な数値目標はデプロイ環境やインフラストラクチャに依存する。
- セキュリティ要件に関しては、デフォルトで多くの機能が無効化されているため、プロダクション環境では認証（`spark.authenticate`）、暗号化（`spark.network.crypto.enabled` または `spark.ssl.rpc.enabled`）、ACL（`spark.acls.enable`）を有効化することを推奨する。
- KubernetesやYARN環境固有の設定については、各リソースマネージャのドキュメントも参照のこと。
