# SQLite

## 概要

SQLiteは、サーバーを必要としない軽量で自己完結型のSQL準拠リレーショナルデータベースエンジンです。C言語で実装されており、組み込みシステムからデスクトップアプリケーション、モバイルアプリまで幅広く使用されています。パブリックドメインソフトウェアとして公開されており、誰でも自由に使用、修正、配布が可能です。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| SQLデータベースエンジン | ACID準拠のトランザクション、完全なSQL92/99サポート |
| 仮想マシン（VDBE） | SQLステートメントをバイトコードにコンパイルして実行 |
| B-Treeストレージ | 効率的なインデックスとデータ格納 |
| クエリオプティマイザ | WHERE句を解析し効率的なクエリプランを生成 |
| 全文検索（FTS3/FTS4/FTS5） | テキストデータに対する高速な全文検索機能 |
| R-Tree | 空間データのインデックスと検索 |
| JSON拡張 | JSON1関数によるJSONデータの操作 |
| セッション拡張 | データベース変更の追跡と差分管理 |
| WALモード | Write-Ahead Loggingによる並行アクセスの向上 |
| 拡張機能ロード | 動的拡張機能のロード機能 |

## 技術スタック

### コア

- 言語: C (C89/C99準拠)
- ビルドシステム: Autosetup / Make / NMAKE (Windows)
- パーサジェネレータ: Lemon (LALR(1)パーサジェネレータ)
- テストフレームワーク: Tcl

### 主要ライブラリ

- pthread (Unix系システムでのスレッドサポート)
- Win32 API (Windowsシステム対応)
- ICU (オプション: 国際化サポート)

### ビルドツール

- GCC / Clang (Unix系)
- MSVC (Windows)
- Tcl 8.6以上 (テスト実行時)

## ディレクトリ構成

```
sqlite-master/
├── src/                    # コアソースコード（約156ファイル、206,000行以上）
│   ├── sqlite.h.in         # 公開APIインターフェース定義
│   ├── sqliteInt.h         # 内部データ構造定義
│   ├── parse.y             # SQL文法定義（Lemon形式）
│   ├── vdbe.c              # 仮想マシン実装
│   ├── where.c             # クエリオプティマイザ
│   ├── btree.c             # B-Treeストレージエンジン
│   ├── pager.c             # ページャ（トランザクション管理）
│   ├── os_unix.c           # Unix VFS実装
│   ├── os_win.c            # Windows VFS実装
│   ├── shell.c.in          # CLIシェルソース
│   └── test*.c             # テスト用コード
├── ext/                    # 拡張機能
│   ├── fts3/               # 全文検索（FTS3/FTS4）
│   ├── fts5/               # 全文検索（FTS5）
│   ├── rtree/              # R-Tree空間インデックス
│   ├── session/            # セッション拡張
│   ├── rbu/                # Resumable Bulk Update
│   ├── misc/               # その他の拡張機能
│   └── wasm/               # WebAssembly対応
├── test/                   # テストスイート（1200以上のテストファイル）
├── tool/                   # ビルド・開発ツール
│   ├── lemon.c             # Lemonパーサジェネレータ
│   ├── mksqlite3c.tcl      # アマルガメーション生成
│   └── mksqlite3h.tcl      # ヘッダファイル生成
├── doc/                    # 内部ドキュメント
├── autosetup/              # Autosetup設定システム
├── autoconf/               # Autoconf設定（レガシー）
├── Makefile.in             # Unix Makefile テンプレート
├── Makefile.msc            # Windows NMAKE ファイル
├── configure               # 設定スクリプト
├── VERSION                 # バージョン情報（3.52.0）
├── LICENSE.md              # ライセンス情報（パブリックドメイン）
└── README.md               # プロジェクト説明
```

## セットアップ

### 必要条件

**Unix/Linux/macOS:**
- GCC または Clang コンパイラ
- Make
- Tcl 8.6以上（テスト実行時のみ）

**Windows:**
- Microsoft Visual C++ (MSVC)
- Tcl（テスト実行時のみ）

### インストール手順

#### Unix/Linux/macOS でのビルド

```bash
# ソースコードの取得
tar xzf sqlite.tar.gz
cd sqlite

# ビルドディレクトリの作成（推奨）
mkdir bld
cd bld

# 設定とビルド
../configure
make sqlite3        # sqlite3 コマンドラインツール
make sqlite3.c      # アマルガメーションソース
make sqldiff        # sqldiff ツール
```

デバッグビルド:
```bash
../configure --all --debug CFLAGS='-O0 -g'
make sqlite3
```

リリースビルド:
```bash
../configure --all
make sqlite3
```

#### Windows でのビルド

```batch
REM TCLパスの設定（テスト実行時）
set TCLDIR=c:\Tcl

REM ビルド
make sqlite3.exe
make sqlite3.c
make sqldiff.exe
```

または nmake を直接使用:
```batch
nmake /f Makefile.msc sqlite3.exe
```

### Fossilによるソース取得

SQLiteは[Fossil](https://fossil-scm.org/)バージョン管理を使用しています。

```bash
mkdir -p ~/sqlite
cd ~/sqlite
fossil open https://sqlite.org/src

# バージョン更新
fossil update trunk             # 最新trunk
fossil update release           # 最新リリース
fossil update version-3.52.0    # 特定バージョン
```

## 開発

### テストの実行

```bash
# 開発テスト（高速）
make devtest

# 完全なリリーステスト
make releasetest

# Tcl拡張のインストール（テスト用）
make tclextension-install
```

### コードスタイル

- C89/C99準拠
- インデント: スペース2つ
- 行長制限なし（ただし可読性を重視）
- 関数名: アンダースコア区切り（例: `sqlite3_open`）

### アマルガメーション

全ソースコードを単一の `sqlite3.c` ファイルにまとめることで、コンパイラの最適化を最大限に活用できます（約5%の性能向上）。

```bash
make target_source    # tsrc/ にソースを収集
make sqlite3.c        # アマルガメーション生成
```

### ソース検証

```bash
make verify-source    # ソースの整合性を検証
```

### コンパイルオプション

追加のコンパイルオプションを指定可能:
```bash
make OPTIONS=-DSQLITE_OMIT_DEPRECATED sqlite3
```

## 関連リンク

- 公式サイト: https://sqlite.org/
- フォーラム: https://sqlite.org/forum
- ソースリポジトリ: https://sqlite.org/src/timeline
- アーキテクチャ解説: https://sqlite.org/arch.html
- ファイルフォーマット: https://sqlite.org/fileformat2.html
- 仮想マシン: https://sqlite.org/opcode.html
