# アーキテクチャ構成図

## 1. システム全体構成図

```mermaid
graph TB
    subgraph "Application Layer"
        APP[Application]
        CLI[sqlite3 CLI<br/>shell.c.in]
        TCL[TCL Extension<br/>tclsqlite.c]
    end

    subgraph "SQLite Core"
        subgraph "Interface Layer"
            API[C API<br/>main.c, sqlite3.h]
            EXT[Extension Loader<br/>loadext.c]
        end

        subgraph "SQL Compiler Layer"
            TOK[Tokenizer<br/>tokenize.c]
            PAR[Parser<br/>parse.y]
            RES[Name Resolver<br/>resolve.c]
            SEL[SELECT Processor<br/>select.c]
            QO[Query Optimizer<br/>where.c]
            CG[Code Generator<br/>expr.c, build.c]
        end

        subgraph "Virtual Machine Layer"
            VDBE[VDBE Engine<br/>vdbe.c]
            VAPI[VDBE API<br/>vdbeapi.c]
            VAUX[VDBE Utilities<br/>vdbeaux.c, vdbemem.c]
            VSORT[VDBE Sorter<br/>vdbesort.c]
        end

        subgraph "B-Tree Layer"
            BT[B-Tree<br/>btree.c]
            BTM[B-Tree Mutex<br/>btmutex.c]
        end

        subgraph "Pager Layer"
            PG[Pager<br/>pager.c]
            PC[Page Cache<br/>pcache.c, pcache1.c]
            WAL[WAL<br/>wal.c]
            MJ[Mem Journal<br/>memjournal.c]
        end

        subgraph "OS Abstraction Layer"
            OS[OS Interface<br/>os.c, os.h]
            UNIX[Unix VFS<br/>os_unix.c]
            WIN[Windows VFS<br/>os_win.c]
        end
    end

    subgraph "Extensions"
        FTS[FTS5<br/>ext/fts5/]
        RTREE[R-Tree<br/>ext/rtree/]
        JSON[JSON<br/>json.c]
        SESSION[Session<br/>ext/session/]
    end

    subgraph "Storage"
        DB[(Database File<br/>.db)]
        JRN[(Journal File<br/>-journal)]
        WALF[(WAL File<br/>-wal)]
    end

    APP --> API
    CLI --> API
    TCL --> API

    API --> TOK
    API --> EXT
    EXT --> FTS
    EXT --> RTREE
    EXT --> JSON
    EXT --> SESSION

    TOK --> PAR
    PAR --> RES
    RES --> SEL
    SEL --> QO
    QO --> CG

    CG --> VDBE
    VDBE --> VAPI
    VDBE --> VAUX
    VDBE --> VSORT

    VDBE --> BT
    BT --> BTM

    BT --> PG
    PG --> PC
    PG --> WAL
    PG --> MJ

    PG --> OS
    WAL --> OS
    OS --> UNIX
    OS --> WIN

    UNIX --> DB
    UNIX --> JRN
    UNIX --> WALF
    WIN --> DB
    WIN --> JRN
    WIN --> WALF
```

## 2. レイヤー構成図

```mermaid
graph TB
    subgraph "Layer 1: Interface"
        L1A[sqlite3_open]
        L1B[sqlite3_prepare]
        L1C[sqlite3_step]
        L1D[sqlite3_finalize]
        L1E[sqlite3_close]
    end

    subgraph "Layer 2: SQL Compiler"
        L2A[Tokenization]
        L2B[Parsing]
        L2C[Semantic Analysis]
        L2D[Query Optimization]
        L2E[Code Generation]
    end

    subgraph "Layer 3: Virtual Machine"
        L3A[Bytecode Execution]
        L3B[Cursor Management]
        L3C[Memory Management]
        L3D[Result Set Generation]
    end

    subgraph "Layer 4: B-Tree"
        L4A[Table Access]
        L4B[Index Access]
        L4C[Cursor Operations]
        L4D[Page Split/Merge]
    end

    subgraph "Layer 5: Pager"
        L5A[Page Cache]
        L5B[Transaction Control]
        L5C[Journaling]
        L5D[WAL Management]
    end

    subgraph "Layer 6: OS Abstraction"
        L6A[File I/O]
        L6B[Locking]
        L6C[Memory Mapping]
        L6D[Synchronization]
    end

    L1A --> L2A
    L1B --> L2A
    L2A --> L2B --> L2C --> L2D --> L2E
    L2E --> L3A
    L1C --> L3A
    L3A --> L3B --> L4A
    L3A --> L3B --> L4B
    L4A --> L5A
    L4B --> L5A
    L5A --> L5B --> L5C --> L6A
    L5B --> L5D --> L6A
    L5C --> L6B
    L5D --> L6B
```

## 3. SQL処理フロー図

```mermaid
sequenceDiagram
    participant App as Application
    participant API as C API
    participant Tok as Tokenizer
    participant Parser as Parser
    participant Optimizer as Optimizer
    participant Gen as Code Generator
    participant VM as VDBE
    participant BT as B-Tree
    participant Pg as Pager
    participant OS as OS Layer
    participant File as File System

    App->>API: sqlite3_prepare_v2(sql)
    API->>Tok: Tokenize SQL
    Tok->>Parser: Token Stream
    Parser->>Optimizer: Parse Tree
    Optimizer->>Gen: Optimized Plan
    Gen->>VM: Bytecode (VDBE Program)
    VM-->>API: Prepared Statement
    API-->>App: sqlite3_stmt*

    loop For each row
        App->>API: sqlite3_step()
        API->>VM: Execute
        VM->>BT: Cursor Operations
        BT->>Pg: Page Access
        Pg->>OS: File I/O (if needed)
        OS->>File: Read/Write
        File-->>OS: Data
        OS-->>Pg: Page Data
        Pg-->>BT: Page
        BT-->>VM: Row Data
        VM-->>API: SQLITE_ROW
        API-->>App: Row Available
    end

    App->>API: sqlite3_finalize()
    API->>VM: Cleanup
    VM-->>API: Done
    API-->>App: SQLITE_OK
```

## 4. トランザクション処理フロー（WALモード）

```mermaid
sequenceDiagram
    participant App as Application
    participant VM as VDBE
    participant BT as B-Tree
    participant Pg as Pager
    participant WAL as WAL Module
    participant Cache as Page Cache
    participant File as File System

    App->>VM: BEGIN TRANSACTION
    VM->>BT: Begin Transaction
    BT->>Pg: Begin
    Pg->>WAL: Begin Write Transaction
    WAL-->>Pg: OK
    Pg-->>BT: OK
    BT-->>VM: OK

    App->>VM: INSERT/UPDATE/DELETE
    VM->>BT: Modify Data
    BT->>Pg: Get Page (Write)
    Pg->>Cache: Fetch Page
    Cache-->>Pg: Page (from cache or disk)
    Pg-->>BT: Writable Page
    BT->>BT: Modify Page in Memory
    BT-->>VM: OK

    App->>VM: COMMIT
    VM->>BT: Commit
    BT->>Pg: Commit
    Pg->>WAL: Write Frames
    WAL->>File: Append to WAL file
    File-->>WAL: OK
    WAL->>File: fsync WAL
    File-->>WAL: OK
    WAL-->>Pg: Commit Complete
    Pg-->>BT: OK
    BT-->>VM: OK
    VM-->>App: SQLITE_OK

    Note over WAL,File: Checkpoint (async)
    WAL->>File: Read WAL frames
    WAL->>File: Write to DB file
    WAL->>File: fsync DB file
    WAL->>File: Reset WAL
```

## 5. B-Tree構造図

```mermaid
graph TB
    subgraph "B-Tree Structure"
        ROOT[Root Page<br/>Internal Node]
        INT1[Internal Page 1]
        INT2[Internal Page 2]
        INT3[Internal Page 3]
        LEAF1[Leaf Page 1<br/>rowid: 1-100]
        LEAF2[Leaf Page 2<br/>rowid: 101-200]
        LEAF3[Leaf Page 3<br/>rowid: 201-300]
        LEAF4[Leaf Page 4<br/>rowid: 301-400]
        LEAF5[Leaf Page 5<br/>rowid: 401-500]
        LEAF6[Leaf Page 6<br/>rowid: 501-600]
    end

    ROOT --> INT1
    ROOT --> INT2
    ROOT --> INT3
    INT1 --> LEAF1
    INT1 --> LEAF2
    INT2 --> LEAF3
    INT2 --> LEAF4
    INT3 --> LEAF5
    INT3 --> LEAF6

    subgraph "Page Structure"
        PH[Page Header<br/>8-12 bytes]
        CELLS[Cell Content Area]
        PTR[Cell Pointers]
        FREE[Free Space]
    end
```

## 6. VDBEオペコード実行フロー

```mermaid
stateDiagram-v2
    [*] --> Init: sqlite3_step()
    Init --> Ready: OP_Init
    Ready --> Fetch: OP_OpenRead/Write
    Fetch --> Seek: OP_Rewind
    Seek --> Compare: OP_SeekGT/GE/LT/LE
    Compare --> Column: OP_Column
    Column --> ResultRow: OP_ResultRow
    ResultRow --> Fetch: More rows
    ResultRow --> Close: No more rows
    Close --> Halt: OP_Close
    Halt --> [*]: SQLITE_DONE

    state Fetch {
        [*] --> OpenCursor
        OpenCursor --> MoveCursor
        MoveCursor --> [*]
    }

    state Compare {
        [*] --> LoadKey
        LoadKey --> BTreeSeek
        BTreeSeek --> CheckResult
        CheckResult --> [*]
    }
```

## 7. ファイルロック状態遷移図

```mermaid
stateDiagram-v2
    [*] --> UNLOCKED
    UNLOCKED --> SHARED: Read Operation
    SHARED --> RESERVED: Begin Write
    RESERVED --> PENDING: Commit Phase 1
    PENDING --> EXCLUSIVE: All SHARED Released
    EXCLUSIVE --> UNLOCKED: Commit Complete
    SHARED --> UNLOCKED: End Read
    RESERVED --> SHARED: Rollback
    PENDING --> SHARED: Rollback (rare)

    note right of SHARED: Multiple readers allowed
    note right of RESERVED: Single writer preparing
    note right of PENDING: Waiting for readers
    note right of EXCLUSIVE: Single writer active
```

## 8. モジュール依存関係図

```mermaid
graph LR
    subgraph "Public API"
        A[sqlite3.h]
    end

    subgraph "Internal Core"
        B[sqliteInt.h]
        C[main.c]
        D[prepare.c]
    end

    subgraph "SQL Processing"
        E[tokenize.c]
        F[parse.y]
        G[resolve.c]
        H[select.c]
        I[where.c]
        J[expr.c]
    end

    subgraph "Virtual Machine"
        K[vdbe.c]
        L[vdbeaux.c]
        M[vdbemem.c]
    end

    subgraph "Storage"
        N[btree.c]
        O[pager.c]
        P[pcache.c]
        Q[wal.c]
    end

    subgraph "OS Layer"
        R[os.c]
        S[os_unix.c]
        T[os_win.c]
    end

    A --> B
    B --> C
    C --> D
    D --> E --> F --> G --> H --> I --> J
    J --> K --> L --> M
    K --> N --> O --> P
    O --> Q
    O --> R --> S
    R --> T
```

## 9. 拡張機能アーキテクチャ図

```mermaid
graph TB
    subgraph "Core SQLite"
        CORE[SQLite Core Engine]
        VTAB[Virtual Table Interface<br/>vtab.c]
        FUNC[Function Interface<br/>func.c]
    end

    subgraph "Built-in Extensions"
        FTS3[FTS3/4<br/>ext/fts3/]
        FTS5[FTS5<br/>ext/fts5/]
        RTREE[R-Tree<br/>ext/rtree/]
        JSON[JSON1<br/>json.c]
        GEOPOLY[GeoPoly<br/>geopoly.c]
    end

    subgraph "Optional Extensions"
        ICU[ICU<br/>ext/icu/]
        RBU[RBU<br/>ext/rbu/]
        SESSION[Session<br/>ext/session/]
        RECOVER[Recover<br/>ext/recover/]
    end

    subgraph "Extension API"
        EXTAPI[sqlite3ext.h]
        LOADEXT[sqlite3_load_extension]
        AUTOEXT[sqlite3_auto_extension]
    end

    CORE --> VTAB
    CORE --> FUNC
    VTAB --> FTS3
    VTAB --> FTS5
    VTAB --> RTREE
    FUNC --> JSON
    VTAB --> GEOPOLY

    EXTAPI --> LOADEXT
    EXTAPI --> AUTOEXT
    LOADEXT --> ICU
    LOADEXT --> RBU
    LOADEXT --> SESSION
    LOADEXT --> RECOVER
```

## 10. メモリ管理構造図

```mermaid
graph TB
    subgraph "Memory Allocator Options"
        MEM1[mem1.c<br/>System malloc]
        MEM2[mem2.c<br/>Debug malloc]
        MEM3[mem3.c<br/>Memsys3]
        MEM5[mem5.c<br/>Memsys5]
    end

    subgraph "Memory Pools"
        SCRATCH[Scratch Memory]
        PCACHE[Page Cache Memory]
        LOOKASIDE[Lookaside Memory]
    end

    subgraph "Memory Consumers"
        VDBEMEM[VDBE Memory<br/>vdbemem.c]
        BTMEM[B-Tree Buffers]
        PGMEM[Pager Buffers]
        PARMEM[Parser Memory]
    end

    subgraph "Memory API"
        MALLOC[sqlite3_malloc]
        REALLOC[sqlite3_realloc]
        FREE[sqlite3_free]
        CONFIG[sqlite3_config]
    end

    CONFIG --> MEM1
    CONFIG --> MEM2
    CONFIG --> MEM3
    CONFIG --> MEM5

    MALLOC --> SCRATCH
    MALLOC --> PCACHE
    MALLOC --> LOOKASIDE

    SCRATCH --> VDBEMEM
    PCACHE --> PGMEM
    LOOKASIDE --> PARMEM
    MALLOC --> BTMEM
```
