# インフラ構成図

## システム全体構成

SQLiteのアーキテクチャは、組み込みデータベースエンジンとしてアプリケーションに直接リンクされる構造を持つ。

```mermaid
graph TB
    subgraph "アプリケーション層"
        APP[アプリケーション]
        CLI[sqlite3 CLI]
        TCL[TCL拡張]
    end

    subgraph "SQLiteコア"
        API[SQLite C API]
        VDBE[Virtual Database Engine<br/>仮想マシン]
        PARSER[SQL Parser<br/>Lemon生成]
        QP[Query Planner<br/>where.c]
        BTREE[B-Tree Engine<br/>btree.c]
        PAGER[Pager<br/>pager.c]
    end

    subgraph "OS抽象化層"
        VFS[VFS Interface]
        UNIX[os_unix.c<br/>Linux/macOS/BSD]
        WIN[os_win.c<br/>Windows]
    end

    subgraph "ストレージ層"
        DB[(Database File<br/>*.db)]
        WAL[(WAL File<br/>*.db-wal)]
        SHM[(SHM File<br/>*.db-shm)]
    end

    APP --> API
    CLI --> API
    TCL --> API
    API --> VDBE
    API --> PARSER
    PARSER --> QP
    VDBE --> QP
    QP --> BTREE
    BTREE --> PAGER
    PAGER --> VFS
    VFS --> UNIX
    VFS --> WIN
    UNIX --> DB
    UNIX --> WAL
    UNIX --> SHM
    WIN --> DB
    WIN --> WAL
    WIN --> SHM
```

## コンポーネント階層

```mermaid
graph LR
    subgraph "Interface Layer"
        A1[sqlite3.h<br/>公開API]
        A2[shell.c<br/>CLI実装]
        A3[tclsqlite.c<br/>TCLバインディング]
    end

    subgraph "SQL Compiler"
        B1[tokenize.c<br/>字句解析]
        B2[parse.y<br/>構文解析]
        B3[resolve.c<br/>名前解決]
        B4[select.c<br/>SELECT処理]
    end

    subgraph "Code Generator"
        C1[expr.c<br/>式処理]
        C2[where.c<br/>WHERE最適化]
        C3[insert.c<br/>INSERT生成]
        C4[update.c<br/>UPDATE生成]
    end

    subgraph "Virtual Machine"
        D1[vdbe.c<br/>VDBE実装]
        D2[vdbeapi.c<br/>VDBE API]
        D3[vdbeaux.c<br/>VDBE補助]
        D4[vdbemem.c<br/>メモリ管理]
    end

    subgraph "B-Tree Storage"
        E1[btree.c<br/>B-Tree本体]
        E2[pager.c<br/>ページ管理]
        E3[pcache.c<br/>ページキャッシュ]
        E4[wal.c<br/>WAL処理]
    end

    subgraph "OS Interface"
        F1[os_unix.c<br/>Unix VFS]
        F2[os_win.c<br/>Windows VFS]
        F3[memdb.c<br/>メモリDB]
    end

    A1 --> B1
    B1 --> B2
    B2 --> B3
    B3 --> B4
    B4 --> C1
    C1 --> C2
    C2 --> D1
    D1 --> E1
    E1 --> E2
    E2 --> F1
    E2 --> F2
```

## ビルドシステム構成

```mermaid
graph TD
    subgraph "構成ファイル"
        CFG[configure]
        AUTO[auto.def]
        MAIN[main.mk]
        MKIN[Makefile.in]
        MSC[Makefile.msc]
        LINUX[Makefile.linux-generic]
    end

    subgraph "生成ファイル"
        MK[Makefile]
        CFGH[sqlite_cfg.h]
        PC[sqlite3.pc]
    end

    subgraph "ビルド成果物"
        LIB[libsqlite3.a<br/>静的ライブラリ]
        DLL[libsqlite3.so<br/>動的ライブラリ]
        EXE[sqlite3<br/>CLI実行ファイル]
        AMAL[sqlite3.c<br/>Amalgamation]
        HDR[sqlite3.h<br/>公開ヘッダ]
    end

    CFG --> MK
    AUTO --> MK
    MAIN --> MK
    MKIN --> MK
    CFG --> CFGH
    CFG --> PC
    MK --> LIB
    MK --> DLL
    MK --> EXE
    MK --> AMAL
    MK --> HDR
    MSC --> LIB
    MSC --> DLL
    MSC --> EXE
    LINUX --> LIB
    LINUX --> EXE
```

## ファイルロック機構

```mermaid
stateDiagram-v2
    [*] --> UNLOCKED: 初期状態
    UNLOCKED --> SHARED: 読み取り要求
    SHARED --> RESERVED: 書き込み準備
    RESERVED --> PENDING: 書き込み待機
    PENDING --> EXCLUSIVE: 排他ロック取得
    EXCLUSIVE --> SHARED: 書き込み完了
    SHARED --> UNLOCKED: 接続解放
    EXCLUSIVE --> UNLOCKED: 接続解放

    note right of SHARED
        複数リーダー許可
    end note

    note right of EXCLUSIVE
        単一ライター
    end note
```

## WAL（Write-Ahead Logging）モード

```mermaid
graph LR
    subgraph "書き込み処理"
        W1[トランザクション開始]
        W2[WALファイル書き込み]
        W3[コミット]
    end

    subgraph "読み取り処理"
        R1[読み取り開始]
        R2[WAL確認]
        R3[DBファイル参照]
    end

    subgraph "チェックポイント"
        CP1[WAL → DB転送]
        CP2[WAL切り詰め]
    end

    W1 --> W2
    W2 --> W3
    R1 --> R2
    R2 --> R3
    W3 --> CP1
    CP1 --> CP2

    DB[(Database<br/>*.db)]
    WAL[(WAL<br/>*.db-wal)]
    SHM[(SHM<br/>*.db-shm)]

    W2 --> WAL
    R3 --> DB
    R2 --> WAL
    CP1 --> DB
    R2 --> SHM
    W2 --> SHM
```

## 拡張機能構成

```mermaid
graph TB
    subgraph "コア拡張"
        FTS3[FTS3/FTS4<br/>全文検索]
        FTS5[FTS5<br/>次世代全文検索]
        RTREE[R-Tree<br/>空間インデックス]
        JSON[JSON1<br/>JSON関数]
    end

    subgraph "セッション拡張"
        SESSION[Session<br/>変更追跡]
        RBU[RBU<br/>一括更新]
    end

    subgraph "その他の拡張"
        ICU[ICU<br/>国際化]
        MISC[ext/misc/*<br/>各種拡張]
        WASM[WASM<br/>WebAssembly]
    end

    CORE[SQLite Core]

    CORE --> FTS3
    CORE --> FTS5
    CORE --> RTREE
    CORE --> JSON
    CORE --> SESSION
    CORE --> RBU
    CORE --> ICU
    CORE --> MISC
    CORE --> WASM
```

## 対応プラットフォーム

```mermaid
graph TB
    subgraph "Unix系"
        LINUX[Linux]
        MACOS[macOS]
        BSD[*BSD]
        QNX[QNX]
        AIX[AIX]
        HPUX[HP-UX]
        VXWORKS[VxWorks]
    end

    subgraph "Windows系"
        WIN32[Windows 32bit]
        WIN64[Windows 64bit]
        WINCE[Windows CE]
    end

    subgraph "WebAssembly"
        WASI[WASI]
        EMSCRIPTEN[Emscripten]
    end

    OS_UNIX[os_unix.c]
    OS_WIN[os_win.c]

    LINUX --> OS_UNIX
    MACOS --> OS_UNIX
    BSD --> OS_UNIX
    QNX --> OS_UNIX
    AIX --> OS_UNIX
    HPUX --> OS_UNIX
    VXWORKS --> OS_UNIX

    WIN32 --> OS_WIN
    WIN64 --> OS_WIN
    WINCE --> OS_WIN

    WASI --> OS_UNIX
    EMSCRIPTEN --> OS_UNIX
```
