# インフラ設計書

## 概要

本ドキュメントは、SQLite 3.52.0のビルド環境、実行環境、およびシステム構成に関するインフラ設計を記載する。SQLiteは組み込み型のリレーショナルデータベースエンジンであり、サーバーレスアーキテクチャを採用している。従来のクライアント/サーバー型データベースとは異なり、独立したサーバープロセスを必要とせず、アプリケーションに直接リンクされて動作する。

## システム構成

### 全体構成

SQLiteは以下の特徴を持つ組み込みデータベースエンジンである:

- **サーバーレスアーキテクチャ**: 独立したサーバープロセスを持たず、アプリケーションプロセス内で直接動作
- **シングルファイルデータベース**: 全てのデータ（テーブル、インデックス、スキーマ等）を単一のディスクファイルに格納
- **ゼロコンフィギュレーション**: インストールや設定作業が不要
- **クロスプラットフォーム**: 複数のOS環境で動作可能

### サーバー構成

SQLiteはサーバーレスアーキテクチャを採用しているため、従来の意味でのサーバー構成は存在しない。代わりに、以下のコンポーネント構成となる:

| コンポーネント | 役割 | 形態 | 備考 |
| --- | --- | --- | --- |
| SQLiteコアライブラリ | データベースエンジン本体 | 静的/動的ライブラリ | libsqlite3.a / libsqlite3.so |
| sqlite3 CLI | コマンドラインインターフェース | 実行可能ファイル | sqlite3 / sqlite3.exe |
| Amalgamation | 単一ソースファイル版 | C言語ソース | sqlite3.c / sqlite3.h |
| TCL拡張 | TCLバインディング | 共有ライブラリ | tclsqlite3.so |

### ネットワーク構成

SQLiteはサーバーレスアーキテクチャのため、ネットワーク通信は行わない。データベースアクセスはローカルファイルシステム経由で行われる。

ただし、アプリケーション層でネットワーク機能を実装する場合は、以下の考慮が必要:

- **VFS（Virtual File System）レイヤー**: カスタムVFSを実装することで、リモートストレージへのアクセスが可能
- **同時アクセス制御**: ファイルロックによる排他制御（POSIX Advisory Locks / Windows LockFile）

## ミドルウェア

| ミドルウェア/依存関係 | バージョン | 用途 |
| --- | --- | --- |
| GCC / Clang / MSVC | - | Cコンパイラ（ビルド環境） |
| GNU Make / BSD Make | - | ビルドシステム |
| TCL | 8.6+ | テスト実行、コード生成 |
| Autosetup | - | 構成スクリプト（configure） |
| JimTCL | - | 代替TCLインタプリタ |
| zlib | - | 圧縮機能（オプション） |
| readline / linenoise | - | CLI行編集（オプション） |
| ICU | - | 国際化対応（オプション） |

## 外部サービス連携

SQLiteは組み込みデータベースであり、外部サービスへの直接的な連携機能は持たない。

| 連携方式 | 用途 | 実装 |
| --- | --- | --- |
| VFS API | カスタムファイルシステム | os_unix.c / os_win.c |
| 拡張機能API | 機能拡張 | loadext.c |
| TCLバインディング | スクリプト言語連携 | tclsqlite.c |

## スケーリング設計

SQLiteは単一プロセス内で動作する組み込みデータベースであり、従来の意味でのスケーリングは適用されない。

### 性能特性

- **同時読み取り**: 複数のリーダーが同時にアクセス可能
- **書き込み**: 単一ライター（排他ロック）
- **WALモード**: Write-Ahead Loggingによる読み書き並行性の向上
- **メモリマップI/O**: 大規模データベースでの性能向上（SQLITE_MAX_MMAP_SIZE）

### 推奨使用シナリオ

- ウェブサイトのトラフィック: 低〜中程度
- 同時接続数: 制限あり（ファイルロックによる）
- データベースサイズ: 最大281TB（理論値）

## 可用性設計

SQLiteの可用性は、ホストシステムのファイルシステムとストレージの信頼性に依存する。

### 冗長構成

- **ジャーナリングモード**: DELETE / TRUNCATE / PERSIST / MEMORY / WAL / OFF
- **推奨モード**: WAL（Write-Ahead Logging）モードによる高い耐障害性
- **チェックポイント機能**: 定期的なWALファイルのデータベースへの反映

### フェイルオーバー方式

SQLiteはサーバーレスのため、従来のフェイルオーバーは不要。アプリケーション層での対応が必要:

- データベースファイルのバックアップ/レプリケーション
- アプリケーションレベルでのリトライ処理

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| データベースファイル | ファイルコピー（HotBackup API） | アプリケーション依存 | アプリケーション依存 |
| WALファイル | 含めてバックアップ | データベースと同時 | チェックポイントまで |

### バックアップ方法

1. **オンラインバックアップAPI**: `sqlite3_backup_init()` / `sqlite3_backup_step()` / `sqlite3_backup_finish()`
2. **ファイルコピー**: WALモード無効時、またはチェックポイント後
3. **.dump コマンド**: SQLダンプによるテキスト形式バックアップ

## 監視設計

SQLiteは組み込みライブラリであるため、外部監視ツールとの統合はアプリケーション層で実装する必要がある。

### 内部監視機能

| 機能 | 用途 |
| --- | --- |
| sqlite3_status() | グローバルランタイム状態の取得 |
| sqlite3_db_status() | データベース接続固有の状態取得 |
| sqlite3_stmt_status() | プリペアドステートメントの状態取得 |
| SQLITE_ENABLE_MEMORY_MANAGEMENT | メモリ使用量の制御 |

### 監視項目

- メモリ使用量（SQLITE_STATUS_MEMORY_USED）
- ページキャッシュ使用量（SQLITE_STATUS_PAGECACHE_USED）
- スキーマ使用量（SQLITE_STATUS_SCHEMA_USED）
- ステートメント使用量（SQLITE_STATUS_STMT_USED）

## ビルド環境

### 対応プラットフォーム

| OS | VFS実装 | ファイルロック |
| --- | --- | --- |
| Linux | os_unix.c | POSIX Advisory Locks |
| macOS | os_unix.c | POSIX / AFP / Proxy Locking |
| Windows | os_win.c | Windows LockFile |
| *BSD | os_unix.c | POSIX Advisory Locks / flock() |
| VxWorks | os_unix.c | Named POSIX Semaphores |
| QNX | os_unix.c | POSIX Advisory Locks |
| AIX / HPUX | os_unix.c | POSIX Advisory Locks |
| WASI | os_unix.c (制限あり) | なし |

### ビルドシステム

| ファイル | 用途 |
| --- | --- |
| configure | Autosetup構成スクリプト |
| auto.def | Autosetup定義ファイル |
| Makefile.in | POSIXメイクファイルテンプレート |
| Makefile.msc | MSVC用メイクファイル |
| Makefile.linux-generic | 汎用Linux用メイクファイル |
| main.mk | 共通ビルドルール |

### コンパイルオプション

主要なコンパイルオプション:

- `-DSQLITE_DEBUG`: デバッグビルド
- `-DSQLITE_ENABLE_FTS5`: 全文検索機能
- `-DSQLITE_ENABLE_RTREE`: R-Tree空間インデックス
- `-DSQLITE_ENABLE_JSON1`: JSON関数
- `-DSQLITE_ENABLE_MEMORY_MANAGEMENT`: メモリ管理機能
- `-DSQLITE_OMIT_DEPRECATED`: 非推奨API除外

## 備考

### ライセンス

SQLiteはパブリックドメインソフトウェアである。著作権は放棄されており、商用・非商用を問わず自由に使用できる。

### バージョン管理

- **バージョン管理システム**: Fossil
- **現在のバージョン**: 3.52.0
- **ソースリポジトリ**: https://sqlite.org/src

### 関連ドキュメント

- 公式ドキュメント: https://sqlite.org/docs.html
- アーキテクチャ概要: https://sqlite.org/arch.html
- ファイルフォーマット: https://sqlite.org/fileformat2.html
- コンパイルガイド（Unix）: doc/compile-for-unix.md
- コンパイルガイド（Windows）: doc/compile-for-windows.md
