---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 32
  claims_with_evidence: 28
  claims_without_evidence: 4
confidence_derived: 0.88
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：28 / 32、根拠なし：4
- 優先レビュー（高）
  1. **SQLite Encryption Extension（SEE）の詳細仕様**：商用製品のため詳細未確認
  2. **監査ログの保持期間**：アプリケーション依存のため具体値なし
  3. **WALチェックポイント間隔のデフォルト値**：要実環境確認
  4. **ファイルパーミッションのデフォルト値**：プラットフォーム依存の可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/auth.c` - 認可コールバック機能の実装
- E-02: `src/sqliteInt.h` - 内部構造とコンパイルオプション定義
- E-03: `src/sqliteLimit.h` - 各種制限値の定義
- E-04: `src/main.c` - API実装とAPI Armor機能
- E-05: `src/mutex.c`, `src/mutex_unix.c` - Mutex実装
- E-06: `src/os_unix.c` - ファイルロック実装
- E-07: `src/pager.c` - ページキャッシュと暗号化フック
- E-08: `src/prepare.c` - Prepared Statement実装
- E-09: `ext/misc/sha1.c` - SHA-1ハッシュ拡張
- E-10: `ext/misc/shathree.c` - SHA-3ハッシュ拡張
- E-11: `ext/misc/cksumvfs.c` - チェックサムVFS拡張
- E-12: `ext/misc/vfstrace.c` - VFSトレース拡張
- E-13: `ext/misc/memtrace.c` - メモリトレース拡張
- E-14: `README.md` - プロジェクト概要と連絡先情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SQLiteはサーバーレスアーキテクチャを採用 | E-14 | ○ |
| C-02 | 標準では認証機構が提供されていない | E-01, E-02 | ○ |
| C-03 | sqlite3_set_authorizer()による認可コールバック | E-01 | ○ |
| C-04 | SQLITE_OK/DENY/IGNOREの3つの返り値 | E-01 | ○ |
| C-05 | DML/DDL操作に対するアクセス制御 | E-01 | ○ |
| C-06 | ファイルベースのためネットワーク通信なし | E-14 | ○ |
| C-07 | 標準機能での暗号化なし | E-07 | ○ |
| C-08 | SHA-1ハッシュ拡張の存在 | E-09 | ○ |
| C-09 | SHA-3ハッシュ拡張の存在 | E-10 | ○ |
| C-10 | デフォルトファイルパーミッション0644 | E-06 | ○ |
| C-11 | sqlite3_bind_*によるパラメータバインディング | E-08 | ○ |
| C-12 | SQLITE_MAX_LENGTH=1,000,000,000 | E-03 | ○ |
| C-13 | SQLITE_MAX_SQL_LENGTH=1,000,000,000 | E-03 | ○ |
| C-14 | SQLITE_MAX_COLUMN=2,000 | E-03 | ○ |
| C-15 | SQLITE_MAX_EXPR_DEPTH=1,000 | E-03 | ○ |
| C-16 | SQLITE_MAX_PARSER_DEPTH=2,500 | E-03 | ○ |
| C-17 | SQLITE_MAX_COMPOUND_SELECT=500 | E-03 | ○ |
| C-18 | SQLITE_MAX_FUNCTION_ARG=1,000 | E-03 | ○ |
| C-19 | SQLITE_MAX_ATTACHED=10 | E-03 | ○ |
| C-20 | SQLITE_MAX_VARIABLE_NUMBER=32,766 | E-03 | ○ |
| C-21 | SQLITE_MAX_TRIGGER_DEPTH=1,000 | E-03 | ○ |
| C-22 | SQLITE_MAX_ALLOCATION_SIZE=2,147,483,391 | E-03 | ○ |
| C-23 | SQLITE_ENABLE_API_ARMORによる引数検証強化 | E-04, E-05 | ○ |
| C-24 | sqlite3SafetyCheckOk()による有効性チェック | E-04 | ○ |
| C-25 | POSIXロック/flock/dot-fileなどのロック方式 | E-06 | ○ |
| C-26 | SQLITE_THREADSAFEオプションの3つのモード | E-02 | ○ |
| C-27 | チェックサムVFS拡張の存在 | E-11 | ○ |
| C-28 | VFSトレース拡張の存在 | E-12 | ○ |
| C-29 | SQLite Encryption Extension（SEE）の詳細 | **根拠なし** | △ |
| C-30 | 監査ログの具体的な保持期間 | **根拠なし** | △ |
| C-31 | WALデフォルトチェックポイント間隔1000フレーム | E-03 | ○ |
| C-32 | メモリ割り当ての256バイト安全マージン | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- **SQLite Encryption Extension（SEE）の詳細**: 商用製品のためソースコード未収録。公式ドキュメント参照が必要
  - 候補：SQLite公式サイト / SEEライセンス文書 / 商用ドキュメント
- **監査ログの保持期間**: アプリケーション側で実装するためSQLiteコアでは規定なし
  - 候補：アプリケーション要件定義 / 運用設計書 / コンプライアンス要件
- **PRAGMA busy_timeoutのデフォルト挙動**: ソースコードで確認済みだが実環境テスト推奨
  - 候補：実環境検証 / SQLite公式テストスイート
- **プラットフォーム固有のファイルパーミッション**: macOS/Linuxでは確認済み、Windows等は別途確認要
  - 候補：os_win.c / プラットフォーム別テスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: SQLITE_MAX_*制限値 - ソースコードで明確に定義されており信頼性高
- **0（低リスク）**: 認可コールバック機能 - auth.cで完全に実装確認済み
- **1（中リスク）**: 暗号化関連 - 標準機能では提供されていないため、必要な場合は拡張機能の導入検討が必要
- **1（中リスク）**: 監査ログ機能 - 標準では提供されていないため、要件に応じてアプリケーション側での実装検討が必要
- **2（高リスク）**: SEE（暗号化拡張）の導入判断 - 機密データを扱う場合は暗号化要件の明確化と商用拡張の導入検討が必須

## 6) レビュアーチェックリスト（最小）
- [ ] 認可コールバック（sqlite3_set_authorizer）の利用要否を確認
- [ ] パラメータバインディングがアプリケーション全体で一貫して使用されているか確認
- [ ] SQLITE_ENABLE_API_ARMORの有効化を検討（本番環境向け）
- [ ] SQLITE_MAX_*制限値がアプリケーション要件に適合しているか確認
- [ ] 機密データを扱う場合、暗号化要件（アプリケーションレベルまたはSEE）を検討
- [ ] ファイルシステム権限がセキュリティポリシーに準拠しているか確認
- [ ] 拡張機能のロード（sqlite3_enable_load_extension）が適切に制限されているか確認
- [ ] スレッドセーフモード（SQLITE_THREADSAFE）が利用パターンに適合しているか確認
