---
generated_at: 2026-01-21 22:41:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **カバレッジ目標100%MC/DC**：公式ドキュメントへの外部参照が必要
  2. **実行時間目安**：実測値ではなく推定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/sqlite-master/README.md`
- E-02: `/Users/tomoka.baba/Work/sqlite-master/main.mk`
- E-03: `/Users/tomoka.baba/Work/sqlite-master/Makefile.in`
- E-04: `/Users/tomoka.baba/Work/sqlite-master/test/all.test`
- E-05: `/Users/tomoka.baba/Work/sqlite-master/test/permutations.test`
- E-06: `/Users/tomoka.baba/Work/sqlite-master/test/tester.tcl`
- E-07: `/Users/tomoka.baba/Work/sqlite-master/test/fuzzcheck.c`
- E-08: `/Users/tomoka.baba/Work/sqlite-master/test/fuzzdata*.db` (8ファイル)
- E-09: `/Users/tomoka.baba/Work/sqlite-master/test/*.test` (約1,185ファイル)
- E-10: `/Users/tomoka.baba/Work/sqlite-master/ext/` (拡張機能テストディレクトリ)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TCL (tclsh 8.5以上) がテストスクリプト実行エンジン | E-01, E-02, E-03 | ○ |
| C-02 | testfixtureがSQLite拡張TCLインタプリタ | E-01, E-02 | ○ |
| C-03 | 約1,185件の.testファイルが存在 | E-09 (実測カウント) | ○ |
| C-04 | fuzzcheckによるファジングテスト | E-02, E-07 | ○ |
| C-05 | fuzzdata1-8.dbがファジングテストデータ | E-02, E-08 | ○ |
| C-06 | make devtestがチェックイン前必須 | E-01, E-02 | ○ |
| C-07 | make quicktestが3分以内目標 | E-02 (コメント記載) | ○ |
| C-08 | make releasetestがリリース用テスト | E-02 | ○ |
| C-09 | make fulltestがalltest + fuzztest | E-02 | ○ |
| C-10 | Valgrindによるメモリ検証サポート | E-02, E-03 | ○ |
| C-11 | veryquick/quick/fullテストスイート存在 | E-04, E-05 | ○ |
| C-12 | malloc/ioerr/fault系テストの除外オプション | E-05 | ○ |
| C-13 | JimTCLがautosetupに同梱 | E-01, E-02 | ○ |
| C-14 | testrunner.tclによる並列テスト実行 | E-02 | ○ |
| C-15 | corrupt*.testで破損データベーステスト | E-05, E-09 | ○ |
| C-16 | thread*.testでマルチスレッドテスト | E-05, E-09 | ○ |
| C-17 | tkt*.testで回帰テスト | E-09 | ○ |
| C-18 | Windows/Unix/macOS対応 | E-01, E-02, E-03 | ○ |
| C-19 | gcovによるカバレッジ測定サポート | E-02, E-03 | ○ |
| C-20 | sessionfuzzによるセッション拡張テスト | E-02 | ○ |
| C-21 | Fossilによるソース管理・真正性検証 | E-01, E-02 | ○ |
| C-22 | 拡張機能が個別テストディレクトリを持つ | E-05, E-10 | ○ |
| C-23 | smoketestがmain.testのみ実行 | E-02 | ○ |
| C-24 | 100%MC/DCカバレッジ目標 | **根拠なし** | △ |
| C-25 | テスト実行時間の具体的目安 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-24 (100%MC/DCカバレッジ目標)**: SQLiteの公式ウェブサイト (sqlite.org) には100%MC/DCカバレッジを達成しているとの記載があるが、ソースコードリポジトリ内にはその明示的な記載がない
  - 候補：sqlite.org公式ドキュメント / SQLite Testing Philosophy文書 / 商用版ドキュメント

- **C-25 (テスト実行時間の具体的目安)**: main.mkの「3分以内」というコメント以外、具体的な実行時間は実測ベースであり、環境依存
  - 候補：実行ログ / ベンチマーク結果 / CI/CDログ

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: テストフレームワーク・ツールに関する記述 - ソースコードで明確に確認可能
- **0 (低リスク)**: テストターゲット一覧 - Makefileで直接確認可能
- **1 (中リスク)**: カバレッジ目標 - 公式サイトの情報を参照しているが、リポジトリ内に直接的根拠なし
- **0 (低リスク)**: テストスイート構成 - permutations.testで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] テストツール一覧が実際のビルド・テスト環境と一致しているか確認
- [ ] make devtest/quicktest/releasetestの実行手順が実環境で動作するか確認
- [ ] カバレッジ目標について、組織のポリシーと整合しているか確認
- [ ] 拡張機能 (FTS5, RTree等) のテストが必要な場合、対応するext/配下のテストファイルを確認
- [ ] CI/CD環境での実行時間が本書の目安と大きく乖離していないか確認
